/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;

public final class FilterContainerData {
    public static final int SIZE = 9;
    private final PlatformResourceKey[] keys = new PlatformResourceKey[9];

    public FilterContainerData() {
    }

    public FilterContainerData(PlatformResourceKey[] values) {
        System.arraycopy(values, 0, this.keys, 0, 9);
    }

    @Nullable
    public PlatformResourceKey get(int slot) {
        return this.keys[slot];
    }

    public void set(int slot, @Nullable PlatformResourceKey key) {
        this.keys[slot] = key;
    }

    public PlatformResourceKey[] values() {
        return this.keys;
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        for (int i = 0; i < 9; ++i) {
            PlatformResourceKey resource = this.keys[i];
            if (resource != null) {
                buf.writeBoolean(true);
                ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)resource);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static FilterContainerData fromNetwork(RegistryFriendlyByteBuf buf) {
        FilterContainerData cmd = new FilterContainerData();
        for (int i = 0; i < 9; ++i) {
            PlatformResourceKey key;
            PlatformResourceKey platformResourceKey = key = buf.readBoolean() ? (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf) : null;
            if (key == null) continue;
            cmd.keys[i] = key;
        }
        return cmd;
    }
}

