/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.CurioStats;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record CurioStatsPacket(UUID storageRef, CurioStats curioStats) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CurioStatsPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier((String)"curio_stats"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CurioStatsPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, CurioStatsPacket>(){

        public CurioStatsPacket decode(RegistryFriendlyByteBuf buf) {
            UUID id = buf.readUUID();
            short tier = buf.readShort();
            short total = buf.readShort();
            short totalStrong = buf.readShort();
            short upgrades = buf.readShort();
            return new CurioStatsPacket(id, new CurioStats(tier, total, totalStrong, upgrades));
        }

        public void encode(RegistryFriendlyByteBuf buf, CurioStatsPacket msg) {
            buf.writeUUID(msg.storageRef);
            buf.writeShort((int)msg.curioStats.type());
            buf.writeShort((int)msg.curioStats.t());
            buf.writeShort((int)msg.curioStats.s());
            buf.writeShort((int)msg.curioStats.u());
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void handle(CurioStatsPacket pkt, PacketContext ctx) {
        OmniGridBlockItem.CLIENT_CURIOS_STATS.put(pkt.storageRef, pkt.curioStats);
    }
}

