/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.OmniResourceAction;
import com.omnigrid.neoforge.OmniResourceDirection;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.EnumMap;
import java.util.EnumSet;

public class CommandValidator {
    private static final EnumMap<OmniResourceAction, EnumSet<ActionConstraint>> ACTION_RULES = new EnumMap(OmniResourceAction.class);

    public static String VerifyCommand(int action, int direction, PlatformResourceKey platformResourceKey) {
        return CommandValidator.VerifyCommand(OmniResourceAction.values()[action], OmniResourceDirection.values()[direction], platformResourceKey);
    }

    public static String VerifyCommand(OmniResourceAction action, OmniResourceDirection direction, PlatformResourceKey resource) {
        EnumSet<ActionConstraint> rules = ACTION_RULES.get((Object)action);
        if (rules == null || rules.isEmpty()) {
            return "";
        }
        int dirOrdinal = direction.ordinal();
        if (resource != null) {
            boolean isItem = resource instanceof ItemResource;
            boolean isFluid = resource instanceof FluidResource;
            if (rules.contains((Object)ActionConstraint.ITEMS_ONLY) && !isItem) {
                return "This command only supports items";
            }
            if (rules.contains((Object)ActionConstraint.ITEMS_FLUID_ONLY) && !isItem && !isFluid) {
                return "This command only supports items or fluids";
            }
            if (rules.contains((Object)ActionConstraint.NOT_FLUID) && isFluid) {
                return "This command cannot use fluids";
            }
            if (rules.contains((Object)ActionConstraint.ITEMS_FLUID_XP_ONLY)) {
                if (isFluid && CommandValidator.isXp(resource)) {
                    return "";
                }
                if (!isItem) {
                    return "This command only supports items";
                }
            }
        }
        if (rules.contains((Object)ActionConstraint.NONE)) {
            return "";
        }
        if (rules.contains((Object)ActionConstraint.ANY) && direction == OmniResourceDirection.NONE) {
            return "Requires a target";
        }
        if (rules.contains((Object)ActionConstraint.REQUIRES_SIDE)) {
            boolean isBlockSide;
            boolean bl = isBlockSide = dirOrdinal >= 2 && dirOrdinal <= 7 && dirOrdinal != 3;
            if (!isBlockSide) {
                return "Requires a side of the block configured";
            }
        }
        if (rules.contains((Object)ActionConstraint.NOT_PLAYER) && (dirOrdinal == 0 || dirOrdinal == 3)) {
            return "Requires target other than player";
        }
        return "";
    }

    private static boolean isXp(PlatformResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return false;
        }
        FluidResource fluid = (FluidResource)resource;
        return fluid.fluid().is(TransferUtils.XP_TAG);
    }

    static {
        ACTION_RULES.put(OmniResourceAction.NONE, EnumSet.noneOf(ActionConstraint.class));
        ACTION_RULES.put(OmniResourceAction.PROVIDE, EnumSet.of(ActionConstraint.REQUIRES_SIDE, ActionConstraint.ITEMS_FLUID_ONLY));
        ACTION_RULES.put(OmniResourceAction.PULL, EnumSet.of(ActionConstraint.ANY));
        ACTION_RULES.put(OmniResourceAction.PUSH, EnumSet.of(ActionConstraint.ANY));
        ACTION_RULES.put(OmniResourceAction.COLLECT, EnumSet.of(ActionConstraint.NONE, ActionConstraint.ITEMS_FLUID_XP_ONLY));
        ACTION_RULES.put(OmniResourceAction.BLACKLIST, EnumSet.of(ActionConstraint.REQUIRES_SIDE, ActionConstraint.ITEMS_FLUID_ONLY));
        ACTION_RULES.put(OmniResourceAction.SEARCH, EnumSet.of(ActionConstraint.REQUIRES_SIDE, ActionConstraint.ITEMS_ONLY));
        ACTION_RULES.put(OmniResourceAction.EXTERNAL_STORAGE, EnumSet.of(ActionConstraint.NOT_PLAYER));
        ACTION_RULES.put(OmniResourceAction.BASIC_CRAFTING, EnumSet.of(ActionConstraint.NONE, ActionConstraint.ITEMS_ONLY));
        ACTION_RULES.put(OmniResourceAction.REGULATE, EnumSet.of(ActionConstraint.ANY, ActionConstraint.ITEMS_FLUID_XP_ONLY));
        ACTION_RULES.put(OmniResourceAction.LOOTING, EnumSet.of(ActionConstraint.NONE, ActionConstraint.ITEMS_ONLY));
    }

    public static enum ActionConstraint {
        NONE,
        ANY,
        REQUIRES_SIDE,
        REQUIRES_BLOCK_TARGET,
        NOT_PLAYER,
        NOT_FLUID,
        ITEMS_ONLY,
        ITEMS_FLUID_ONLY,
        ITEMS_FLUID_XP_ONLY;

    }
}

