/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Utils;

import com.omnigrid.Utils.ResourcePrinter;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.world.item.Items;

public class CobblePrinterStorage
implements Storage,
ResourcePrinter {
    private static final ItemResource COBBLE = new ItemResource(Items.COBBLESTONE);
    private static final long VISIBLE_AMOUNT = Integer.MAX_VALUE;

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        ItemResource item;
        if (resource instanceof ItemResource && (item = (ItemResource)resource).item() == Items.COBBLESTONE) {
            return amount;
        }
        return 0L;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return 0L;
    }

    public Collection<ResourceAmount> getAll() {
        return Collections.singletonList(new ResourceAmount((ResourceKey)COBBLE, Integer.MAX_VALUE));
    }

    public long getStored() {
        return Integer.MAX_VALUE;
    }

    @Override
    public float getDrainForExtraction(long amount) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        float fePerCobble = cfg.cobbleCost();
        return fePerCobble * (float)amount;
    }

    @Override
    public ResourceKey getPrintedResource() {
        return COBBLE;
    }
}

