/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.StorageProxy.ResourceChestContainerMenu;
import com.omnigrid.neoforge.BlockEntities;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Optional;
import java.util.function.ToLongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ResourceChestBlockEntity
extends BlockEntity
implements ExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    public ResourceContainerImpl resourceContainer;
    private static final String TAG_CONTENTS = "tc";
    private static final int SIZE = 9;
    private final Container exportedResourcesAsContainer;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public ResourceChestBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntities.INSTANCE.getResourceChest(), pos, blockState);
        this.resourceContainer = ResourceChestBlockEntity.createExportedResourcesContainer();
        this.exportedResourcesAsContainer = this.resourceContainer.toItemContainer();
    }

    public static ResourceContainerImpl createExportedResourcesContainer() {
        ToLongFunction<ResourceKey> maxAmountProvider = resource -> {
            if (resource instanceof ItemResource) {
                return 64L;
            }
            if (resource instanceof FluidResource) {
                return 16000L;
            }
            return 0L;
        };
        return new ResourceContainerImpl(9, maxAmountProvider, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_CONTENTS, (Tag)this.resourceContainer.toTag(provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_CONTENTS)) {
            this.resourceContainer.fromTag(tag.getCompound(TAG_CONTENTS), provider);
        }
        super.loadAdditional(tag, provider);
    }

    public static ResourceChestBlockEntity create(BlockPos pos, BlockState state) {
        return new ResourceChestBlockEntity(pos, state);
    }

    public static ResourceContainer createFilterContainer(ResourceContainerData containerData) {
        ResourceContainerImpl filterContainer = ResourceChestBlockEntity.createExportedResourcesContainer();
        for (int i = 0; i < containerData.resources().size(); ++i) {
            int ii = i;
            ((Optional)containerData.resources().get(i)).ifPresent(arg_0 -> ResourceChestBlockEntity.lambda$createFilterContainer$1((ResourceContainer)filterContainer, ii, arg_0));
        }
        return filterContainer;
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.resourceContainer);
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.setChanged();
    }

    public Container getExportedResourcesAsContainer() {
        return this.exportedResourcesAsContainer;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Resource Repository");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new ResourceChestContainerMenu(i, player, this, (ResourceContainer)this.resourceContainer);
    }

    public final NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.create();
        for (int i = 0; i < this.exportedResourcesAsContainer.getContainerSize(); ++i) {
            drops.add((Object)this.exportedResourcesAsContainer.getItem(i));
        }
        return drops;
    }

    private static /* synthetic */ void lambda$createFilterContainer$1(ResourceContainer filterContainer, int ii, ResourceAmount resource) {
        filterContainer.set(ii, resource);
    }
}

