/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.StorageProxy.OmniDispenser;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ProxyPortBlock
extends AbstractBaseBlock
implements EntityBlock {
    private static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public ProxyPortBlock() {
        super(BlockConstants.PROPERTIES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return OmniDispenser.create(pos, state);
    }

    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void updateActiveState(boolean active, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)ACTIVE) && (Boolean)state.getValue((Property)ACTIVE) != active) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return ProxyPortBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.CONSUME;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof OmniDispenser)) {
            return ItemInteractionResult.CONSUME;
        }
        OmniDispenser proxy = (OmniDispenser)be;
        Item item = stack.getItem();
        if (item instanceof OmniGridBlockItem) {
            OmniGridBlockItem odi = (OmniGridBlockItem)item;
            ItemInteractionResult result = TransferUtils.handleStorageProxyUse(stack, state, level, pos, player, hit, proxy);
            return result;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            proxy.selectedDirection = hit.getDirection();
            sp.openMenu((MenuProvider)proxy, buf -> ResourceContainerData.STREAM_CODEC.encode(buf, (Object)ResourceContainerData.of((ResourceContainer)proxy.getSupplier(proxy.selectedDirection).get())));
        }
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (!(be instanceof StorageProxy)) {
                return;
            }
            StorageProxy proxy = (StorageProxy)be;
            proxy.updateActiveness();
        };
    }
}

