/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.StorageProxy.AbstractDepositProxy;
import com.omnigrid.StorageProxy.OmniPort;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.support.AbstractBaseBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ProxyDepositBlock
extends AbstractBaseBlock
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");

    public ProxyDepositBlock() {
        super(BlockConstants.PROPERTIES);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OmniPort(pos, state);
    }

    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return ProxyDepositBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    }

    public void updateActiveState(boolean active, Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.hasProperty((Property)ACTIVE) && (Boolean)state.getValue((Property)ACTIVE) != active) {
            level.setBlock(pos, (BlockState)state.setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        AbstractDepositProxy proxy;
        block9: {
            block8: {
                block7: {
                    if (level.isClientSide) {
                        return ItemInteractionResult.CONSUME;
                    }
                    BlockEntity be = level.getBlockEntity(pos);
                    if (!(be instanceof AbstractDepositProxy)) {
                        return ItemInteractionResult.CONSUME;
                    }
                    proxy = (AbstractDepositProxy)be;
                    Item item = stack.getItem();
                    if (!(item instanceof OmniGridBlockItem)) break block7;
                    OmniGridBlockItem odi = (OmniGridBlockItem)item;
                    break block8;
                }
                if (!stack.isEmpty()) break block9;
            }
            ItemInteractionResult result = TransferUtils.handleStorageProxyUse(stack, state, level, pos, player, hit, proxy);
            proxy.updateActiveState();
            return result;
        }
        if (!stack.isEmpty()) {
            if (stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                this.depositSingleFluidContainer(proxy, stack, player, hand);
                return ItemInteractionResult.SUCCESS;
            }
            this.depositSingleItemStack(proxy, stack);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void depositSingleItemStack(AbstractDepositProxy proxy, ItemStack stack) {
        ItemStack leftover = proxy.handler.insertItem(0, stack.copy(), false);
        stack.setCount(leftover.getCount());
    }

    private void depositSingleFluidContainer(AbstractDepositProxy proxy, ItemStack stack, Player player, InteractionHand hand) {
        IFluidHandlerItem handler = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (handler == null) {
            return;
        }
        boolean changed = false;
        for (int t = 0; t < handler.getTanks(); ++t) {
            FluidStack fluid = handler.getFluidInTank(t);
            int amount = proxy.handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            if (amount > 0) {
                fluid.shrink(amount);
                handler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                changed = true;
                continue;
            }
            int drained = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE).getAmount();
            if (drained != 1000) continue;
            fluid.shrink(1000);
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            changed = true;
        }
        if (changed) {
            player.setItemInHand(hand, handler.getContainer().copy());
            player.getInventory().setChanged();
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (!(be instanceof StorageProxy)) {
                return;
            }
            StorageProxy proxy = (StorageProxy)be;
            proxy.updateActiveness();
        };
    }
}

