/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.customRender.OmniClientBlockPacket;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.AbstractOmniGridEntity;
import com.omnigrid.neoforge.InteractionUtils;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OmniProxyRemoteItem
extends Item {
    public OmniProxyRemoteItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        UUID linkedGrid = this.getLinkedGrid(stack);
        if (linkedGrid == null) {
            this.onUnlinkedUse(serverPlayer, stack);
            return InteractionResultHolder.fail((Object)stack);
        }
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(linkedGrid);
        if (proxxy == null || proxxy.isDirty()) {
            this.onInvalidLink(serverPlayer, stack, linkedGrid);
            return InteractionResultHolder.fail((Object)stack);
        }
        this.onRemoteUse(serverPlayer, stack, proxxy);
        player.getCooldowns().addCooldown((Item)this, 5);
        return InteractionResultHolder.success((Object)stack);
    }

    protected void onRemoteUse(ServerPlayer player, ItemStack stack, OmniItemProxxy proxxy) {
        AbstractOmniGridEntity abs;
        AbstractOmniGridBlockEntity<?> be = ModInitializer.validateRemote(proxxy, (Player)player);
        if (!(be instanceof AbstractOmniGridEntity) || !proxxy.uuid.equals((abs = (AbstractOmniGridEntity)be).getStorageReference())) {
            player.displayClientMessage((Component)Component.literal((String)"Omni Grid not found!"), true);
            return;
        }
        if (!InteractionUtils.canInteractWithBlock((Player)player, player.level(), be.getBlockPos(), Direction.UP)) {
            return;
        }
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.getMenuOpener().openMenu(player, (MenuProvider)abs);
    }

    protected void onUnlinkedUse(ServerPlayer player, ItemStack stack) {
        player.displayClientMessage((Component)Component.literal((String)"No Omni Grid linked").withStyle(ChatFormatting.RED), true);
    }

    protected void onInvalidLink(ServerPlayer player, ItemStack stack, UUID id) {
        player.displayClientMessage((Component)Component.literal((String)"Linked Omni Grid is unavailable").withStyle(ChatFormatting.RED), true);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!isSelected) {
            return;
        }
        if (level.getGameTime() % 60L != 0L) {
            return;
        }
        if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(stack.get(DataComponents.INSTANCE.getStorageReference()))) {
            OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(stack.get(DataComponents.INSTANCE.getStorageReference()));
            com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)new OmniClientBlockPacket(proxxy.uuid, proxxy.getCachedData().blockTargets));
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AbstractOmniGridContainerMenu) {
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.storageReference == proxxy.uuid) {
                    proxxy.stress += (float)Platform.getConfig().getOmniGrid().getProxyEnergyUsage();
                }
            }
        }
    }

    @Nullable
    protected UUID getLinkedGrid(ItemStack stack) {
        return (UUID)stack.get(DataComponents.INSTANCE.getStorageReference());
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        int baseRange = Platform.getConfig().getOmniGrid().getProxyBaseRange();
        int perUpgrade = Platform.getConfig().getOmniGrid().getProxyExtraRangePerUpgrade();
        MutableComponent text = Component.literal((String)"Omni Proxy Remote").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)"Allows remote access to a placed Omni Grid. Use this on a placed Omni Grid to link. \nYou may shift left-click block entities with this to register block targets on the linked Omni Grids behalf").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n\n")).append((Component)Component.literal((String)"Range: ").withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)(baseRange + " blocks")).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" base").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n")).append((Component)Component.literal((String)" + ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(perUpgrade + " blocks")).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" per Range Upgrade").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)"\n\n")).append((Component)Component.literal((String)"Universal Accessor: ").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)"Ignores range limits").withStyle(ChatFormatting.GREEN));
        return Optional.of(new HelpTooltipComponent((Component)text));
    }
}

