/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class OmniPortHandler
implements IItemHandler,
IFluidHandler,
IEnergyStorage {
    public static final Set<StorageProxy> LOADED = new HashSet<StorageProxy>();
    private final Supplier<BlockPos> blockPosValidator;
    private final Supplier<UUID> uuid;
    private final Supplier<ResourceContainer> resourceContainer;
    private final int SIZE = 9;
    public RateLimiter checkStorage = RateLimiter.create((double)0.1);
    private final boolean isDeposit;
    private final boolean cannotExtract;

    public OmniPortHandler(Supplier<UUID> linkedOmniGrid, Supplier<BlockPos> blockPos, Supplier<ResourceContainer> resourceContainer, boolean isDeposit) {
        this.uuid = linkedOmniGrid;
        this.blockPosValidator = blockPos;
        this.resourceContainer = resourceContainer;
        this.isDeposit = isDeposit;
        this.cannotExtract = false;
    }

    public OmniPortHandler(Supplier<UUID> linkedOmniGrid, Supplier<BlockPos> blockPos) {
        this.uuid = linkedOmniGrid;
        this.blockPosValidator = blockPos;
        this.resourceContainer = () -> null;
        this.isDeposit = true;
        this.cannotExtract = true;
    }

    public boolean verifyHandler() {
        if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.uuid.get())) {
            Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
            OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.uuid.get());
            if (proxy.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
                return true;
            }
            int range = cfg.getProxyBaseRange() + cfg.getProxyExtraRangePerUpgrade() * proxy.getRange();
            return OmniPortHandler.withinRange(proxy.taskCenterPosition, this.blockPosValidator.get(), range);
        }
        return false;
    }

    @Nullable
    private OmniRootStorage getStorage() {
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.uuid.get());
        if (!this.verifyHandler()) {
            return null;
        }
        return proxy.getOrCreateStorage();
    }

    public int getTanks() {
        return 9;
    }

    public FluidStack getFluidInTank(int i) {
        return this.resolveTank(i);
    }

    public int getTankCapacity(int i) {
        return 1000;
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (!this.isDeposit) {
            return 0;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null || stack.isEmpty()) {
            return 0;
        }
        FluidResource resource = new FluidResource(stack.getFluid());
        long amount = stack.getAmount();
        long inserted = storage.insert((ResourceKey)resource, amount, action == IFluidHandler.FluidAction.EXECUTE ? Action.EXECUTE : Action.SIMULATE, (Actor)new PlayerActor("Omni Deposit at " + String.valueOf(this.blockPosValidator.get())));
        return (int)inserted;
    }

    public FluidStack drain(FluidStack request, IFluidHandler.FluidAction action) {
        if (this.cannotExtract) {
            return FluidStack.EMPTY;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null || request.isEmpty()) {
            return FluidStack.EMPTY;
        }
        for (int i = 0; i < 9; ++i) {
            FluidResource fluidRes;
            ResourceKey resourceKey;
            ResourceAmount ra = this.resourceContainer.get().get(i);
            if (ra == null || !((resourceKey = ra.resource()) instanceof FluidResource) || !(fluidRes = (FluidResource)resourceKey).fluid().isSame(request.getFluid())) continue;
            long available = storage.get((ResourceKey)fluidRes);
            long toDrain = Math.min((long)request.getAmount(), available);
            if (toDrain <= 0L) {
                return FluidStack.EMPTY;
            }
            if (action.execute()) {
                storage.extract((ResourceKey)fluidRes, toDrain, Action.EXECUTE, (Actor)new PlayerActor("Omni Dispenser at" + String.valueOf(this.blockPosValidator)));
            }
            return new FluidStack(request.getFluid(), (int)toDrain);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        ResourceKey resourceKey;
        if (amount <= 0) {
            return FluidStack.EMPTY;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null) {
            return FluidStack.EMPTY;
        }
        ResourceAmount res = this.resourceContainer.get().get(0);
        if (res == null || !((resourceKey = res.resource()) instanceof FluidResource)) {
            return FluidStack.EMPTY;
        }
        FluidResource fluidRes = (FluidResource)resourceKey;
        long available = storage.get((ResourceKey)fluidRes);
        long toDrain = Math.min((long)amount, available);
        if (toDrain <= 0L) {
            return FluidStack.EMPTY;
        }
        if (action.execute()) {
            storage.extract((ResourceKey)fluidRes, toDrain, Action.EXECUTE, (Actor)new PlayerActor("Omni Dispenser at" + String.valueOf(this.blockPosValidator.get())));
        }
        return new FluidStack(fluidRes.fluid(), (int)toDrain);
    }

    public int getSlots() {
        return 9;
    }

    public ItemStack getStackInSlot(int i) {
        return this.resolveSlot(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        long amount;
        if (!this.isDeposit) {
            return stack;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null || stack.isEmpty()) {
            return stack;
        }
        ItemResource resource = ItemResource.ofItemStack((ItemStack)stack);
        long inserted = storage.insert((ResourceKey)resource, amount = (long)stack.getCount(), simulate ? Action.SIMULATE : Action.EXECUTE, (Actor)new PlayerActor("Omni Deposit at " + String.valueOf(this.blockPosValidator.get())));
        if (inserted <= 0L) {
            return stack;
        }
        if (inserted >= amount) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = stack.copy();
        remainder.setCount((int)(amount - inserted));
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ResourceKey resourceKey;
        if (this.cannotExtract) {
            return ItemStack.EMPTY;
        }
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null) {
            return ItemStack.EMPTY;
        }
        ResourceAmount res = this.resourceContainer.get().get(slot);
        if (res == null || !((resourceKey = res.resource()) instanceof ItemResource)) {
            return ItemStack.EMPTY;
        }
        ItemResource itemRes = (ItemResource)resourceKey;
        long available = storage.get((ResourceKey)itemRes);
        if (available <= 0L) {
            return ItemStack.EMPTY;
        }
        long toExtract = Math.min((long)amount, available);
        if (!simulate) {
            storage.extract((ResourceKey)itemRes, toExtract, Action.EXECUTE, (Actor)new PlayerActor("Omni Port at" + String.valueOf(this.blockPosValidator.get())));
        }
        return itemRes.toItemStack().copyWithCount((int)toExtract);
    }

    public int getSlotLimit(int i) {
        return 9;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isDeposit;
    }

    public ItemStack resolveSlot(int i) {
        ResourceKey resourceKey;
        if (this.resourceContainer == null || this.resourceContainer.get() == null) {
            return ItemStack.EMPTY;
        }
        ResourceAmount resourceAmount = this.resourceContainer.get().get(i);
        if (this.getStorage() == null || resourceAmount == null || !((resourceKey = resourceAmount.resource()) instanceof ItemResource)) {
            return ItemStack.EMPTY;
        }
        ItemResource itemResource = (ItemResource)resourceKey;
        int amt = Math.toIntExact(Math.min(64L, this.getStorage().get((ResourceKey)itemResource)));
        return itemResource.toItemStack().copyWithCount(amt);
    }

    public FluidStack resolveTank(int i) {
        ResourceKey resourceKey;
        if (this.resourceContainer == null || this.resourceContainer.get() == null) {
            return FluidStack.EMPTY;
        }
        ResourceAmount resourceAmount = this.resourceContainer.get().get(i);
        if (this.getStorage() == null || resourceAmount == null || !((resourceKey = resourceAmount.resource()) instanceof FluidResource)) {
            return FluidStack.EMPTY;
        }
        FluidResource fluidResource = (FluidResource)resourceKey;
        int amt = Math.toIntExact(Math.min(1000L, this.getStorage().get((ResourceKey)fluidResource)));
        return new FluidStack(fluidResource.fluid(), amt);
    }

    public static boolean withinRange(BlockPos a, BlockPos b, int range) {
        if (a == null || b == null) {
            return false;
        }
        return Math.abs(a.getX() - b.getX()) <= range && Math.abs(a.getY() - b.getY()) <= range && Math.abs(a.getZ() - b.getZ()) <= range;
    }

    public int receiveEnergy(int amount, boolean simulate) {
        if (!this.isDeposit || !RefinedTypesUtil.rtInstalled()) {
            return 0;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null) {
            return 0;
        }
        Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
        return (int)storage.insert((ResourceKey)EnergyResource.createEnergyResource(), amount, action, (Actor)new PlayerActor("Omni Deposit at" + String.valueOf(this.blockPosValidator.get())));
    }

    public int extractEnergy(int i, boolean b) {
        if (this.cannotExtract || !RefinedTypesUtil.rtInstalled()) {
            return 0;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage == null) {
            return 0;
        }
        for (int o = 0; o < 9; ++o) {
            ResourceAmount res = this.resourceContainer.get().get(o);
            if (res == null || !(res.resource() instanceof EnergyResource)) continue;
            Action action = b ? Action.SIMULATE : Action.EXECUTE;
            return (int)storage.extract(res.resource(), i, action, (Actor)new PlayerActor("Omni Port at" + String.valueOf(this.blockPosValidator.get())));
        }
        return 0;
    }

    public int getEnergyStored() {
        if (!RefinedTypesUtil.rtInstalled()) {
            return 0;
        }
        OmniRootStorage storage = this.getStorage();
        if (storage != null) {
            return Math.toIntExact(Math.min(1000000L, storage.get((ResourceKey)EnergyResource.createEnergyResource())));
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (!RefinedTypesUtil.rtInstalled()) {
            return 0;
        }
        return 1000000;
    }

    public boolean canExtract() {
        return RefinedTypesUtil.rtInstalled();
    }

    public boolean canReceive() {
        if (RefinedTypesUtil.rtInstalled()) {
            return this.isDeposit;
        }
        return false;
    }
}

