/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.StorageProxy.AbstractOmniDispenser;
import com.omnigrid.StorageProxy.OmniPortHandler;
import com.omnigrid.StorageProxy.ProxyPortBlock;
import com.omnigrid.neoforge.BlockEntities;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniDispenser
extends AbstractOmniDispenser
implements ExtendedMenuProvider<ResourceContainerData> {
    private final int SIZE = 9;
    private final HashMap<Direction, OmniPortHandler> directionalHandlers = new HashMap();
    private boolean lastActive = false;
    private final RateLimiter rateLimiter = RateLimiter.create((double)1.0);
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniDispenser.class);

    public OmniDispenser(BlockPos pos, BlockState state, boolean advancedVariant, boolean isHub) {
        super(BlockEntities.INSTANCE.getOmniPort(), pos, state, advancedVariant, isHub);
        if (this.advanced) {
            for (Direction direction : Direction.values()) {
                this.directionalHandlers.put(direction, new OmniPortHandler(this::getStorageReference, () -> ((OmniDispenser)this).getBlockPos(), this.getSupplier(direction), isHub));
            }
        } else {
            this.directionalHandlers.put(Direction.UP, new OmniPortHandler(this::getStorageReference, () -> ((OmniDispenser)this).getBlockPos(), this.getSupplier(Direction.UP), isHub));
        }
    }

    public static OmniDispenser create(BlockPos pos, BlockState state) {
        boolean advanced = state.getBlock().getDescriptionId().toLowerCase().contains("advanced");
        boolean hub = state.getBlock().getDescriptionId().toLowerCase().contains("hub");
        return new OmniDispenser(pos, state, advanced, hub);
    }

    @Override
    public void setStorageReference(UUID uuid) {
        this.storageReference = uuid;
    }

    @Override
    public UUID getStorageReference() {
        return this.storageReference;
    }

    @Override
    public void updateActiveness() {
        this.updateActiveState();
    }

    public void updateActiveState() {
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        boolean nowActive = this.directionalHandlers.get(Direction.UP).verifyHandler();
        if (nowActive != this.lastActive) {
            Block block;
            this.lastActive = nowActive;
            if (this.level != null && !this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof ProxyPortBlock) {
                ProxyPortBlock block2 = (ProxyPortBlock)block;
                block2.updateActiveState(nowActive, this.level, this.worldPosition);
            }
            this.setChanged();
        }
    }

    public OmniPortHandler getSuper(Direction side) {
        if (!this.advanced) {
            return this.directionalHandlers.get(Direction.UP);
        }
        return this.directionalHandlers.get(side);
    }

    public ResourceContainerData getMenuData() {
        if (this.advanced) {
            return ResourceContainerData.of((ResourceContainer)this.getSupplier(this.selectedDirection).get());
        }
        return ResourceContainerData.of((ResourceContainer)this.getSupplier(Direction.UP).get());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getDisplayName() {
        if (this.advanced) {
            String capital = Arrays.stream(this.selectedDirection.getName().split("_")).map(s -> Character.toUpperCase(s.charAt(0)) + s.substring(1)).collect(Collectors.joining(" "));
            return Component.literal((String)capital);
        }
        return Component.literal((String)"Omni Port");
    }
}

