/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.OmniVoider;
import com.omnigrid.neoforge.DataComponents;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyType;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceFilterContainerMenu<T extends BlockEntity>
extends AbstractResourceContainerMenu {
    private static final int FILTER_SLOT_X = 8;
    private static final int FILTER_SLOT_Y = 20;
    private final Component filterHelp;
    private ResourceContainer resourceContainer;
    public ItemStack itemStack;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractResourceFilterContainerMenu.class);

    protected AbstractResourceFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainer resourceContainer, Component filterHelp) {
        super(type, syncId, player);
        this.filterHelp = filterHelp;
        this.resourceContainer = resourceContainer;
        this.addSlots(player, resourceContainer);
    }

    protected AbstractResourceFilterContainerMenu(MenuType<?> type, int syncId, Player player, ResourceContainerData resourceContainerData, Component filterHelp) {
        super(type, syncId);
        this.filterHelp = filterHelp;
        this.resourceContainer = ResourceContainerImpl.createForFilter((ResourceContainerData)resourceContainerData);
        this.addSlots(player, this.resourceContainer);
    }

    protected abstract void registerClientProperties();

    protected abstract void registerServerProperties(T var1);

    private void addSlots(Player player, ResourceContainer resourceContainer) {
        for (int i = 0; i < resourceContainer.size(); ++i) {
            this.addSlot(this.createFilterSlot(resourceContainer, i));
        }
        this.addPlayerInventory(player.getInventory(), 8, 55);
        this.transferManager.addBiTransfer(resourceContainer.toItemContainer(), (Container)player.getInventory());
    }

    private Slot createFilterSlot(ResourceContainer resourceContainer, int i) {
        int x = 8 + 18 * i;
        return new ResourceSlot(resourceContainer, i, this.filterHelp, x, 20, ResourceSlotType.FILTER);
    }

    public <T> ClientProperty<T> getProperty(PropertyType<T> type) {
        return new ClientProperty(null, null);
    }

    public void clicked(int id, int dragType, ClickType clickType, Player p) {
        Slot slot;
        Slot slot2 = slot = id >= 0 ? this.getSlot(id) : null;
        if (slot != null && slot.getItem().getItem() instanceof OmniVoider) {
            return;
        }
        super.clicked(id, dragType, clickType, p);
    }

    public void setDisabledSlot(SlotReference sr) {
        this.disabledSlot = sr;
    }

    public void removed(Player player) {
        if (!player.level().isClientSide() && this.disabledSlot != null) {
            ((ItemStack)this.disabledSlot.resolve(player).get()).set(DataComponents.INSTANCE.getFilterData(), (Object)new OmniFilterData(this.resourceContainer));
        }
    }
}

