/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.Utils.OmniSelfNetwork;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.storage.DiskStateChangeListener;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOmniStorageProxy<T extends AbstractStorageContainerNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T>
implements AbstractStorageContainerNetworkNode.Provider,
StorageProxy,
EnergyProvider {
    public final DiskStateChangeListener diskStateListener = new DiskStateChangeListener((BlockEntity)this);
    public boolean isActive = false;
    private boolean resolved = false;
    private boolean isController = false;
    public UUID storageReference;
    public OmniProxxyStorage storage;
    private int initialCounter = 0;
    private RateLimiter activenessDetector = RateLimiter.create((double)0.1);
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOmniStorageProxy.class);

    protected AbstractOmniStorageProxy(BlockEntityType<?> type, BlockPos pos, BlockState state, T node) {
        super(type, pos, state, node);
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setListener((StateTrackedStorage.Listener)this.diskStateListener);
    }

    public Component getName() {
        return Component.literal((String)"Omni Storage Proxy");
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.initialize(this.level);
        }
    }

    public Optional<Storage> resolve(int i) {
        if (this.storageReference == null || this.worldPosition == null) {
            return Optional.empty();
        }
        OmniItemProxxy proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.storageReference);
        if (proxy == null) {
            return Optional.empty();
        }
        if (this.storage == null || !this.storageReference.equals(this.storage.id)) {
            this.storage = new OmniProxxyStorage(this.storageReference);
            if (!proxy.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
                this.storage.thisPosition = this.worldPosition;
            }
        }
        return Optional.of(this.storage);
    }

    public void doWork() {
        if (this.initialCounter < 100) {
            ++this.initialCounter;
            if (this.initialCounter >= 100 || this.initialCounter == 50) {
                this.setChanged();
                this.diskStateListener.onStorageStateChanged();
            }
        }
        if (this.activenessDetector.tryAcquire()) {
            if (this.storageReference != null && OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.storageReference)) {
                OmniItemProxxy prox = OmniGridBlockItem.GLOBAL_STORAGES.get(this.storageReference);
                long baseConsumption = Platform.getConfig().getOmniGrid().getProxyEnergyUsage();
                ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setEnergyUsage(baseConsumption);
            }
            this.activenessChanged(true);
            this.setChanged();
        }
        if (!this.resolved) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)this.getBlockState().getBlock().asItem());
            this.isController = id.getPath().contains("controller");
        }
        if (this.isController && this.storageReference != null) {
            if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.storageReference)) {
                if (((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null || !(((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() instanceof OmniSelfNetwork)) {
                    ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setNetwork((Network)new OmniSelfNetwork(this.storageReference));
                    ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setActive(true);
                }
            } else {
                ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setNetwork(null);
            }
        }
        super.doWork();
    }

    public void reset() {
        this.initialCounter = 0;
    }

    private void initialize(Level level) {
        ((AbstractStorageContainerNetworkNode)this.mainNetworkNode).setProvider((AbstractStorageContainerNetworkNode.Provider)this);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (!level.isClientSide()) {
            this.initialize(level);
        }
    }

    public void activenessChanged(boolean newActive) {
        super.activenessChanged(newActive);
        PlatformUtil.sendBlockUpdateToClient((Level)this.level, (BlockPos)this.worldPosition);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("sid")) {
            this.storageReference = tag.getUUID("sid");
        }
        super.loadAdditional(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.storageReference != null) {
            tag.putUUID("sid", this.storageReference);
        }
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (((AbstractStorageContainerNetworkNode)this.mainNetworkNode).getNetwork() == null) {
            return tag;
        }
        return tag;
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }
}

