/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.omnigrid.StorageProxy.OmniPortContainerMenu;
import com.omnigrid.StorageProxy.OmniPortHandler;
import com.omnigrid.StorageProxy.StorageProxy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractOmniDispenser
extends BlockEntity
implements MenuProvider,
StorageProxy {
    public UUID storageReference;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private final Map<Direction, ResourceContainer> filters = new EnumMap<Direction, ResourceContainer>(Direction.class);
    private final Map<Direction, Supplier<ResourceContainer>> suppliers = new EnumMap<Direction, Supplier<ResourceContainer>>(Direction.class);
    public Direction selectedDirection = Direction.UP;
    public final boolean advanced;
    public final boolean isDeposit;

    public AbstractOmniDispenser(BlockEntityType<?> type, BlockPos pos, BlockState state, boolean advanced, boolean isDeposit) {
        super(type, pos, state);
        this.advanced = advanced;
        this.isDeposit = isDeposit;
        for (Direction dir : Direction.values()) {
            ResourceContainer c = ResourceContainerImpl.createForFilter((int)9);
            this.filters.put(dir, c);
            this.suppliers.put(dir, () -> this.filters.get(dir));
        }
    }

    public ResourceContainer getTopContainer() {
        return this.filters.get(Direction.UP);
    }

    public ResourceContainer getResourcesByDirection(Direction dir) {
        return this.advanced ? this.filters.get(dir) : this.filters.get(Direction.UP);
    }

    public Supplier<ResourceContainer> getSupplier(Direction dir) {
        return this.advanced ? this.suppliers.get(dir) : this.suppliers.get(Direction.UP);
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new OmniPortContainerMenu(id, player, this, this.getResourcesByDirection(this.selectedDirection));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.storageReference != null) {
            tag.putUUID("StorageRef", this.storageReference);
        }
        for (Direction dir : Direction.values()) {
            ResourceContainer container = this.filters.get(dir);
            if (container == null || container.getResources().isEmpty()) continue;
            CompoundTag dirTag = new CompoundTag();
            dirTag.put("rf", (Tag)container.toTag(provider));
            tag.put("Filter_" + dir.getName(), (Tag)dirTag);
        }
        OmniPortHandler.LOADED.remove(this);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("StorageRef")) {
            this.storageReference = tag.getUUID("StorageRef");
        }
        for (Direction dir : Direction.values()) {
            String key = "Filter_" + dir.getName();
            ResourceContainer container = this.filters.get(dir);
            if (container == null) continue;
            if (tag.contains(key)) {
                CompoundTag dirTag = tag.getCompound(key);
                if (!dirTag.contains("rf")) continue;
                container.fromTag(dirTag.getCompound("rf"), provider);
                continue;
            }
            container.clear();
        }
        super.loadAdditional(tag, provider);
        OmniPortHandler.LOADED.add(this);
    }
}

