/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.StorageProxy;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.StorageProxy.OmniPortHandler;
import com.omnigrid.StorageProxy.ProxyDepositBlock;
import com.omnigrid.StorageProxy.StorageProxy;
import com.omnigrid.Utils.OmniProxxyStorage;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDepositProxy
extends BlockEntity
implements StorageProxy {
    public boolean isActive = false;
    public OmniPortHandler handler;
    public UUID storageReference;
    public OmniProxxyStorage storage;
    private boolean lastActive = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDepositProxy.class);
    private static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private final RateLimiter rateLimiter = RateLimiter.create((double)1.0);

    protected AbstractDepositProxy(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.handler = new OmniPortHandler(this::getStorageReference, () -> ((AbstractDepositProxy)this).getBlockPos());
    }

    public void updateActiveState() {
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        boolean nowActive = this.handler.verifyHandler();
        if (nowActive != this.lastActive) {
            Block block;
            this.lastActive = nowActive;
            if (this.level != null && !this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof ProxyDepositBlock) {
                ProxyDepositBlock block2 = (ProxyDepositBlock)block;
                block2.updateActiveState(nowActive, this.level, this.worldPosition);
            }
            this.setChanged();
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.storageReference = tag.contains("sid") ? tag.getUUID("sid") : null;
        super.loadAdditional(tag, provider);
        this.updateActiveState();
        OmniPortHandler.LOADED.add(this);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.storageReference != null) {
            tag.putUUID("sid", this.storageReference);
        }
        OmniPortHandler.LOADED.remove(this);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

