/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.Regulator;

import com.omnigrid.Regulator.RestrictionMode;
import com.omnigrid.neoforge.DataComponents;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeState;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class OmniRegulator
extends RegulatorUpgradeItem {
    public OmniRegulator(UpgradeRegistry registry) {
        super(registry);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            RestrictionMode mode = (RestrictionMode)((Object)stack.get(DataComponents.INSTANCE.getRestrictionMode()));
            if (mode == null) {
                mode = RestrictionMode.INSERT_LIMIT;
            }
            RestrictionMode next = RestrictionMode.VALUES[(mode.id() + 1) % RestrictionMode.VALUES.length];
            stack.set(DataComponents.INSTANCE.getRestrictionMode(), (Object)next);
            if (!level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)("Restriction Mode: \u00a7e" + next.name())), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(DataComponents.INSTANCE.getRestrictionMode(), (Object)RestrictionMode.INSERT_LIMIT);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        RegulatorUpgradeState regulate;
        RestrictionMode mode = (RestrictionMode)((Object)stack.get(DataComponents.INSTANCE.getRestrictionMode()));
        if (mode == null) {
            mode = RestrictionMode.INSERT_LIMIT;
        }
        lines.add((Component)Component.literal((String)"Mode: ").append((Component)Component.literal((String)mode.getDisplayName()).withStyle(ChatFormatting.YELLOW)));
        if (stack.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getRegulatorUpgradeState()) && (regulate = (RegulatorUpgradeState)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getRegulatorUpgradeState())).resource().isPresent()) {
            Object t = regulate.resource().get();
            if (t instanceof ItemResource) {
                ItemResource ir = (ItemResource)t;
                lines.add((Component)Component.literal((String)"Resource: ").append(ir.toItemStack().getHoverName()).withStyle(ChatFormatting.GREEN));
            } else {
                t = regulate.resource().get();
                if (t instanceof FluidResource) {
                    FluidResource fluidResource = (FluidResource)t;
                }
            }
            lines.add((Component)Component.literal((String)("Amount: " + regulate.amount())).withStyle(ChatFormatting.AQUA));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        RestrictionMode mode = (RestrictionMode)((Object)stack.get(DataComponents.INSTANCE.getRestrictionMode()));
        if (mode == null) {
            mode = RestrictionMode.INSERT_LIMIT;
        }
        String modeName = mode.getDisplayName();
        MutableComponent full = Component.literal((String)"\u00a7ePlaced in an Omni Grids utility slot to add a restriction on how it handles a resource. Right-click to configure resource and quantity, shift right-click to change mode. \n\n").append((Component)(switch (mode) {
            case RestrictionMode.INSERT_LIMIT -> Component.literal((String)"Insert: Prevents inserting resources beyond the configured limit.");
            case RestrictionMode.EXTRACT_FLOOR -> Component.literal((String)"Extract: Prevents extracting resources if doing so would drop below the minimum amount.");
            case RestrictionMode.BOTH -> Component.literal((String)"Both: Applies both insert and extract limits for this resource.");
            default -> Component.literal((String)"No restriction mode active.");
        }));
        return Optional.of(new HelpTooltipComponent((Component)full));
    }
}

