/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.storage;

import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class BankItemHandler
implements IItemHandler {
    private final List<ItemStack> items;
    private final Map<Integer, ItemStack> lockedSlots;
    private final PickupMode pickupMode;
    private final BankType type;
    private final int slotCapacity;
    private final Runnable setChanged;
    @Nullable
    private Runnable capabilityInvalidator;
    private boolean invalidated = false;

    public BankItemHandler(List<ItemStack> items, Map<Integer, ItemStack> lockedSlots, BankType type, PickupMode pickupMode, Runnable setChanged) {
        this.items = items;
        this.lockedSlots = lockedSlots;
        this.pickupMode = pickupMode;
        this.type = type;
        this.slotCapacity = type.stackLimit;
        this.setChanged = setChanged;
    }

    private void setChanged() {
        this.setChanged.run();
    }

    public int getSlots() {
        return this.type.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.items.get(slot);
    }

    public ItemStack insertItem(ItemStack stack) {
        return this.insertItem(0, stack, false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.invalidated) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (Util.isDisallowedInBank(stack)) {
            return stack;
        }
        int maxAmount = stack.getCount();
        int inserted = 0;
        switch (this.pickupMode) {
            case NONE: {
                return stack;
            }
            case ALL: {
                inserted += this.insertIntoLockedSlots(stack, maxAmount - inserted, simulate);
                inserted += this.insertIntoNonEmptySlots(stack, maxAmount - inserted, simulate);
                inserted += this.insertIntoAnySlots(stack, maxAmount - inserted, simulate);
                break;
            }
            case FILTERED: {
                inserted += this.insertIntoLockedSlots(stack, maxAmount - inserted, simulate);
                inserted += this.insertIntoNonEmptySlots(stack, maxAmount - inserted, simulate);
                if (!this.hasSlotWithItem(stack)) break;
                inserted += this.insertIntoAnySlots(stack, maxAmount - inserted, simulate);
                break;
            }
            case VOID: {
                if (!this.hasSlotWithItem(stack)) break;
                inserted += this.insertIntoLockedSlots(stack, maxAmount - inserted, simulate);
                this.insertIntoNonEmptySlots(stack, maxAmount - inserted, simulate);
                inserted = maxAmount;
            }
        }
        if (inserted > 0) {
            this.setChanged();
        }
        return inserted == 0 ? stack : (inserted == maxAmount ? ItemStack.EMPTY : stack.copyWithCount(maxAmount - inserted));
    }

    private int insertIntoLockedSlots(ItemStack stack, int amount, boolean simulate) {
        if (amount == 0) {
            return 0;
        }
        int inserted = 0;
        for (int slot : this.lockedSlots.keySet()) {
            ItemStack lockedStack = this.lockedSlots.get(slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)lockedStack, (ItemStack)stack)) {
                ItemStack stackInSlot = this.items.get(slot);
                int count = stackInSlot.getCount();
                int spaceLeft = this.slotCapacity - count;
                int toInsert = amount - inserted;
                int gotInserted = Math.min(spaceLeft, toInsert);
                inserted += gotInserted;
                if (!simulate) {
                    this.items.set(slot, stack.copyWithCount(count + gotInserted));
                }
            }
            if (inserted != amount) continue;
            break;
        }
        return inserted;
    }

    private int insertIntoNonEmptySlots(ItemStack stack, int amount, boolean simulate) {
        if (amount == 0) {
            return 0;
        }
        int inserted = 0;
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack stackInSlot = this.items.get(slot);
            int count = stackInSlot.getCount();
            if (count == 0) continue;
            if (ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
                int spaceLeft = this.slotCapacity - count;
                int toInsert = amount - inserted;
                int gotInserted = Math.min(spaceLeft, toInsert);
                inserted += gotInserted;
                if (!simulate) {
                    this.items.set(slot, stack.copyWithCount(count + inserted));
                }
            }
            if (inserted == amount) break;
        }
        return inserted;
    }

    private int insertIntoAnySlots(ItemStack stack, int amount, boolean simulate) {
        if (amount == 0) {
            return 0;
        }
        int inserted = 0;
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack lockedStack = this.lockedSlots.get(slot);
            ItemStack stackInSlot = this.items.get(slot);
            int count = stackInSlot.getCount();
            if (lockedStack != null ? ItemStack.isSameItemSameComponents((ItemStack)lockedStack, (ItemStack)stack) : stackInSlot.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) {
                int spaceLeft = this.slotCapacity - count;
                int toInsert = amount - inserted;
                int gotInserted = Math.min(spaceLeft, toInsert);
                inserted += gotInserted;
                if (!simulate) {
                    this.items.set(slot, stack.copyWithCount(count + inserted));
                }
            }
            if (inserted == amount) break;
        }
        return inserted;
    }

    private boolean hasSlotWithItem(ItemStack stack) {
        for (ItemStack lockedStack : this.lockedSlots.values()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)lockedStack, (ItemStack)stack)) continue;
            return true;
        }
        for (ItemStack stackInSlot : this.items) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.invalidated) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.items.get(slot);
        int count = stackInSlot.getCount();
        int extracted = Math.min(count, amount);
        if (extracted == 0) {
            return ItemStack.EMPTY;
        }
        if (!simulate) {
            this.items.set(slot, stackInSlot.copyWithCount(count - extracted));
        }
        this.setChanged();
        return stackInSlot.copyWithCount(extracted);
    }

    public int getSlotLimit(int slot) {
        return this.slotCapacity;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.getItem().canFitInsideContainerItems();
    }

    public void setInvalidator(Runnable capabilityInvalidator) {
        this.capabilityInvalidator = capabilityInvalidator;
    }

    public void invalidate() {
        if (this.capabilityInvalidator != null) {
            this.capabilityInvalidator.run();
            this.invalidated = true;
        }
    }
}

