/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.storage;

import java.util.Collections;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.container.BankItemStorage;

public class BankContainer
implements Container {
    private final BankItemStorage bankItemStorage;
    private final List<ItemStack> items;

    public BankContainer(BankItemStorage bankItemStorage) {
        this.bankItemStorage = bankItemStorage;
        this.items = bankItemStorage.getItems();
    }

    public int getContainerSize() {
        return this.bankItemStorage.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.items.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.items, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.items.get(slot);
        this.items.set(slot, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.items.set(slot, stack);
    }

    public void setChanged() {
        this.bankItemStorage.markDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        Collections.fill(this.items, ItemStack.EMPTY);
    }
}

