/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.state;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.container.BankType;

public class BankSerializer {
    private static final Codec<ItemStack> LARGE_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));
    private static final Codec<ItemStack> OPTIONAL_LARGE_STACK_CODEC = BankSerializer.airIfError(BankSerializer.optionalOrEmptyMap(LARGE_STACK_CODEC));
    private static final Codec<ItemStack> OPTIONAL_SINGLE_ITEM_CODEC = BankSerializer.airIfError(BankSerializer.optionalOrEmptyMap((Codec<ItemStack>)ItemStack.SINGLE_ITEM_CODEC));
    private static final Codec<BankItemStorage> BANK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.STRING_CODEC.fieldOf("uuid").forGetter(BankItemStorage::uuid), (App)BankType.CODEC.fieldOf("type").forGetter(BankItemStorage::type), (App)OPTIONAL_LARGE_STACK_CODEC.listOf().fieldOf("items").forGetter(BankItemStorage::getItems), (App)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::valueOf, String::valueOf), OPTIONAL_SINGLE_ITEM_CODEC).fieldOf("locked_slots").forGetter(BankItemStorage::getLockedSlots), (App)Codec.STRING.lenientOptionalFieldOf("date_created", (Object)LocalDateTime.now().toString()).forGetter(b -> b.dateCreated.toString()), (App)UUIDUtil.STRING_CODEC.lenientOptionalFieldOf("last_used_by_uuid", (Object)BankStorage.FAKE_PLAYER_UUID).forGetter(b -> b.usedByPlayerUUID), (App)ExtraCodecs.PLAYER_NAME.lenientOptionalFieldOf("last_used_by_player", (Object)"World").forGetter(b -> b.usedByPlayerName)).apply((Applicative)instance, BankItemStorage::createFromCodec));
    public static final Codec<List<BankItemStorage>> CODEC = BANK_CODEC.listOf();

    private static Codec<ItemStack> optionalOrEmptyMap(Codec<ItemStack> codec) {
        return ExtraCodecs.optionalEmptyMap(codec).xmap(maybeStack -> maybeStack.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    }

    private static Codec<ItemStack> airIfError(Codec<ItemStack> codec) {
        return Codec.withAlternative(codec, (Codec)Codec.unit((Object)ItemStack.EMPTY));
    }
}

