/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.state;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.state.BankSerializer;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class BankPersistentState
extends SavedData {
    private static final String BANK_DATA_KEY = "bank_data";
    private final Map<UUID, BankItemStorage> BANK_MAP = new HashMap<UUID, BankItemStorage>();

    public static BankPersistentState createFromNbt(CompoundTag nbtCompound, HolderLookup.Provider registryLookup) {
        BankPersistentState state = new BankPersistentState();
        state.BANK_MAP.clear();
        if (!FMLLoader.isProduction()) {
            BankStorage.LOGGER.debug("Loading banks from nbt");
        }
        List banks = (List)BankSerializer.CODEC.parse((DynamicOps)registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbtCompound.get(BANK_DATA_KEY)).getOrThrow();
        for (BankItemStorage bank : banks) {
            state.BANK_MAP.put(bank.uuid(), bank);
        }
        if (!FMLLoader.isProduction()) {
            BankStorage.LOGGER.debug("Loading done");
        }
        return state;
    }

    public CompoundTag save(CompoundTag nbtCompound, HolderLookup.Provider registryLookup) {
        if (!FMLLoader.isProduction()) {
            BankStorage.LOGGER.debug("Saving banks to nbt");
        }
        Tag bankNbt = (Tag)BankSerializer.CODEC.encodeStart((DynamicOps)registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.getBankItemStorages()).getOrThrow();
        nbtCompound.put(BANK_DATA_KEY, bankNbt);
        if (!FMLLoader.isProduction()) {
            BankStorage.LOGGER.debug("Saving done");
        }
        return nbtCompound;
    }

    @Nullable
    public BankItemStorage get(UUID uuid) {
        return this.BANK_MAP.get(uuid);
    }

    public BankItemStorage getOrCreate(UUID uuid, BankType type) {
        BankItemStorage bank = this.BANK_MAP.get(uuid);
        if (bank == null) {
            bank = new BankItemStorage(type, uuid);
            bank.initializeItems();
            this.set(uuid, bank);
        }
        if (bank.type() != type) {
            bank = bank.asType(type);
            this.set(uuid, bank);
        }
        return bank;
    }

    public void set(UUID uuid, BankItemStorage bankItemStorage) {
        this.BANK_MAP.put(uuid, bankItemStorage);
    }

    public List<BankItemStorage> getBankItemStorages() {
        return List.copyOf(this.BANK_MAP.values());
    }
}

