/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.packet.server;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.screen.BankScreenHandler;
import net.natte.bankstorage.util.Util;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LockSlotPacketC2S(int syncId, int slot, ItemStack stack, boolean shouldLock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LockSlotPacketC2S> TYPE = new CustomPacketPayload.Type(Util.ID("lock_slot_c2s"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LockSlotPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LockSlotPacketC2S::syncId, (StreamCodec)ByteBufCodecs.INT, LockSlotPacketC2S::slot, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, LockSlotPacketC2S::stack, (StreamCodec)ByteBufCodecs.BOOL, LockSlotPacketC2S::shouldLock, LockSlotPacketC2S::new);

    public CustomPacketPayload.Type<LockSlotPacketC2S> type() {
        return TYPE;
    }

    public static void handle(LockSlotPacketC2S packet, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        AbstractContainerMenu screenHandler = player.containerMenu;
        if (!(screenHandler instanceof BankScreenHandler)) {
            return;
        }
        BankScreenHandler bankScreenHandler = (BankScreenHandler)screenHandler;
        if (packet.shouldLock) {
            bankScreenHandler.lockSlot(packet.slot, packet.stack);
        } else {
            bankScreenHandler.unlockSlot(packet.slot);
        }
        bankScreenHandler.lockedSlotsMarkDirty();
    }
}

