/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.options;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Random;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.natte.bankstorage.options.BuildMode;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.options.SortMode;

public record BankOptions(PickupMode pickupMode, BuildMode buildMode, SortMode sortMode, short uniqueId) {
    public static final BankOptions DEFAULT = new BankOptions(PickupMode.NONE, BuildMode.NONE_NORMAL, SortMode.COUNT, 0);
    public static final StreamCodec<ByteBuf, BankOptions> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.pickupMode.ordinal(), (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.buildMode.ordinal(), (StreamCodec)ByteBufCodecs.BYTE, o -> (byte)o.sortMode.ordinal(), (StreamCodec)ByteBufCodecs.SHORT, BankOptions::uniqueId, BankOptions::of);
    private static final Random random = new Random();
    public static final Codec<BankOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BYTE.fieldOf("pickup").forGetter(o -> (byte)o.pickupMode.ordinal()), (App)Codec.BYTE.fieldOf("build").forGetter(o -> (byte)o.buildMode.ordinal()), (App)Codec.BYTE.fieldOf("sort").forGetter(o -> (byte)o.sortMode.ordinal()), (App)Codec.SHORT.fieldOf("id").orElseGet(() -> (short)random.nextInt()).forGetter(o -> o.uniqueId)).apply((Applicative)instance, BankOptions::of));

    public static BankOptions of(byte pickupMode, byte buildMode, byte sortMode, short uniqueId) {
        return new BankOptions(PickupMode.values()[pickupMode], BuildMode.values()[buildMode], SortMode.values()[sortMode], uniqueId);
    }

    public static BankOptions create() {
        return new BankOptions(PickupMode.NONE, BuildMode.NONE_NORMAL, SortMode.COUNT, (short)random.nextInt());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BankOptions options = (BankOptions)other;
        return this.pickupMode == options.pickupMode && this.buildMode == options.buildMode && this.sortMode == options.sortMode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.pickupMode, this.buildMode, this.sortMode});
    }

    public BankOptions withBuildMode(BuildMode newBuildMode) {
        return new BankOptions(this.pickupMode, newBuildMode, this.sortMode, this.uniqueId);
    }

    public BankOptions nextBuildMode() {
        return this.withBuildMode(this.buildMode.next());
    }

    public BankOptions withSortMode(SortMode newSortMode) {
        return new BankOptions(this.pickupMode, this.buildMode, newSortMode, this.uniqueId);
    }

    public BankOptions nextPickupMode() {
        return new BankOptions(this.pickupMode.next(), this.buildMode, this.sortMode, this.uniqueId);
    }
}

