/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.container.CachedBankStorage;
import net.natte.bankstorage.item.tooltip.BankTooltipData;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.BuildMode;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.screen.BankScreenHandlerFactory;
import net.natte.bankstorage.util.Util;
import org.jetbrains.annotations.Nullable;

public abstract class BankFunctionality
extends Item {
    public BankFunctionality(Item.Properties settings) {
        super(settings);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    private InteractionResult useBank(Player player, ItemStack bank, InteractionHand hand, boolean usedOnBlock, @Nullable BlockHitResult hitResult) {
        boolean openWhenUsedOnBlock;
        boolean tryOpenWhenUsedOnAir;
        boolean shouldToggleBuildMode;
        Level world = player.level();
        boolean isBuildMode = Util.getOrCreateOptions(bank).buildMode().isActive();
        boolean hasBoundKey = Util.isBuildModeToggleKeyBound(player);
        if (bank.getCount() != 1) {
            return InteractionResult.FAIL;
        }
        boolean bl = shouldToggleBuildMode = !usedOnBlock && player.isShiftKeyDown() && !hasBoundKey;
        if (shouldToggleBuildMode) {
            if (!world.isClientSide) {
                this.toggleBuildMode(bank, (ServerPlayer)player);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        boolean bl2 = tryOpenWhenUsedOnAir = !usedOnBlock;
        if (tryOpenWhenUsedOnAir) {
            if (isBuildMode && hasBoundKey) {
                return InteractionResult.FAIL;
            }
            return this.tryOpenBank(world, player, hand, bank);
        }
        boolean bl3 = openWhenUsedOnBlock = usedOnBlock && !isBuildMode;
        if (openWhenUsedOnBlock) {
            return this.tryOpenBank(world, player, hand, bank);
        }
        return this.build(new UseOnContext(world, player, hand, bank, hitResult));
    }

    private void toggleBuildMode(ItemStack bankItem, ServerPlayer player) {
        BankOptions options = Util.getOrCreateOptions(bankItem);
        BuildMode newBuildMode = Util.isBuildModeCycleKeyBound((Player)player) ? options.buildMode().toggle() : options.buildMode().next();
        bankItem.set(BankStorage.OptionsComponentType, (Object)options.withBuildMode(newBuildMode));
        player.displayClientMessage((Component)Component.translatable((String)("popup.bankstorage.buildmode." + newBuildMode.toString().toLowerCase())), true);
    }

    private InteractionResult tryOpenBank(Level world, Player player, InteractionHand hand, ItemStack bank) {
        if (world.isClientSide) {
            return InteractionResult.CONSUME;
        }
        @Nullable BankItemStorage bankItemStorage = Util.getBankItemStorage(bank);
        if (bankItemStorage == null) {
            player.displayClientMessage((Component)Component.translatable((String)"popup.bankstorage.unlinked"), true);
            return InteractionResult.FAIL;
        }
        bankItemStorage.usedByPlayerUUID = player.getUUID();
        bankItemStorage.usedByPlayerName = player.getName().getString();
        int slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().selected : 40;
        BankScreenHandlerFactory screenHandlerFactory = new BankScreenHandlerFactory(bankItemStorage.type(), bankItemStorage, bank, slot, ContainerLevelAccess.NULL);
        player.openMenu((MenuProvider)screenHandlerFactory, screenHandlerFactory::writeScreenOpeningData);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult build(UseOnContext context) {
        ItemStack blockToPlace;
        Player player = context.getPlayer();
        ItemStack bank = context.getItemInHand();
        Level world = context.getLevel();
        Random random = world.isClientSide ? Util.clientSyncedRandom : (Random)player.getData(BankStorage.SYNCED_RANDOM_ATTACHMENT);
        BankOptions options = Util.getOrCreateOptions(bank);
        int selectedSlot = (Integer)bank.getOrDefault(BankStorage.SelectedSlotComponentType, (Object)0);
        BankItemStorage bankItemStorage = null;
        if (world.isClientSide) {
            @Nullable CachedBankStorage cachedBankStorage = CachedBankStorage.getBankStorage(bank);
            if (cachedBankStorage == null) {
                if (Util.isLink(bank)) {
                    player.displayClientMessage((Component)Component.translatable((String)"popup.bankstorage.unlinked"), true);
                }
                return InteractionResult.FAIL;
            }
            blockToPlace = cachedBankStorage.chooseItemToPlace(options, random, selectedSlot);
        } else {
            bankItemStorage = Util.getBankItemStorage(bank);
            if (bankItemStorage == null) {
                if (Util.isLink(bank)) {
                    player.displayClientMessage((Component)Component.translatable((String)"popup.bankstorage.unlinked"), true);
                }
                return InteractionResult.FAIL;
            }
            bankItemStorage.usedByPlayerUUID = player.getUUID();
            bankItemStorage.usedByPlayerName = player.getName().getString();
            blockToPlace = bankItemStorage.chooseItemToPlace(options, random, selectedSlot);
        }
        int count = blockToPlace.getCount();
        blockToPlace.setCount(1);
        InteractionResult useResult = blockToPlace.useOn(new UseOnContext(world, player, context.getHand(), blockToPlace, context.hitResult));
        blockToPlace.setCount(blockToPlace.getCount() == 1 ? count : count - 1);
        ItemStack itemInHand = player.getItemInHand(context.getHand());
        if (itemInHand != bank) {
            ItemStack remaining;
            if (!(world.isClientSide || player.hasInfiniteMaterials() || (remaining = bankItemStorage.getItemHandler(PickupMode.ALL).insertItem(itemInHand.copy())).isEmpty())) {
                player.getInventory().placeItemBackInInventory(remaining);
            }
            player.setItemInHand(context.getHand(), bank);
        }
        if (world.isClientSide) {
            CachedBankStorage.requestCacheUpdate(Util.getUUID(bank));
        }
        if (bankItemStorage != null) {
            bankItemStorage.markDirty();
        }
        return useResult;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack bank = player.getItemInHand(hand);
        InteractionResult result = this.useBank(player, bank, hand, false, null);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case InteractionResult.CONSUME, InteractionResult.CONSUME_PARTIAL, InteractionResult.FAIL, InteractionResult.SUCCESS -> InteractionResultHolder.consume((Object)bank);
            case InteractionResult.PASS -> InteractionResultHolder.pass((Object)bank);
            case InteractionResult.SUCCESS_NO_ITEM_USED -> InteractionResultHolder.success((Object)bank);
        };
    }

    public InteractionResult useOn(UseOnContext context) {
        return this.useBank(context.getPlayer(), context.getItemInHand(), context.getHand(), true, context.hitResult);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (Util.isShiftDown.get().booleanValue()) {
            return Optional.empty();
        }
        CachedBankStorage cachedBankStorage = CachedBankStorage.getAndThrottleUpdate(stack, 20);
        if (cachedBankStorage == null) {
            return Optional.empty();
        }
        List<ItemStack> nonEmptyItems = cachedBankStorage.getNonEmptyItems();
        if (nonEmptyItems.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BankTooltipData(nonEmptyItems));
    }

    public boolean isNotReplaceableByPickAction(ItemStack stack, Player player, int inventorySlot) {
        return true;
    }
}

