/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.container;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.options.BankOptions;
import net.natte.bankstorage.options.BuildMode;
import net.natte.bankstorage.options.PickupMode;
import net.natte.bankstorage.state.BankStateManager;
import net.natte.bankstorage.storage.BankContainer;
import net.natte.bankstorage.storage.BankItemHandler;
import org.jetbrains.annotations.Nullable;

public class BankItemStorage {
    private final BankType type;
    private final UUID uuid;
    private List<ItemStack> items;
    private Map<Integer, ItemStack> lockedSlots;
    private short lockedSlotsRevision = 0;
    private short revision = 1;
    public UUID usedByPlayerUUID = BankStorage.FAKE_PLAYER_UUID;
    public String usedByPlayerName = "World";
    public LocalDateTime dateCreated;
    @Nullable
    private BankItemStorage upgraded = null;
    private List<Runnable> invalidators = new ArrayList<Runnable>();

    public BankItemStorage(BankType type, UUID uuid) {
        this.type = type;
        this.uuid = uuid;
        this.lockedSlots = new HashMap<Integer, ItemStack>();
        this.dateCreated = LocalDateTime.now();
    }

    public void initializeItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.type.size(); ++i) {
            list.add(ItemStack.EMPTY);
        }
        this.items = list;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public BankType type() {
        return this.type;
    }

    public BankItemStorage asType(BankType type) {
        assert (type.size() >= this.type.size()) : "Cannot downgrade banks!";
        if (this.type != type) {
            if (type.size() < this.type.size()) {
                return this;
            }
            return this.changeType(type);
        }
        return this;
    }

    public BankItemStorage changeType(BankType type) {
        BankStorage.LOGGER.debug("Upgrading bank from {} to {} uuid {}", new Object[]{this.type.getName(), type.getName(), this.uuid});
        assert (type.size() > this.type.size()) : "Cannot downgrade banks!";
        BankItemStorage newBankItemStorage = new BankItemStorage(type, this.uuid);
        newBankItemStorage.initializeItems();
        for (int i = 0; i < this.items.size(); ++i) {
            newBankItemStorage.items.set(i, this.items.get(i));
        }
        newBankItemStorage.lockedSlots = this.lockedSlots;
        this.onUpgrade(newBankItemStorage);
        return newBankItemStorage;
    }

    private void onUpgrade(BankItemStorage newBankItemStorage) {
        this.upgraded = newBankItemStorage;
        this.invalidators.forEach(Runnable::run);
        this.invalidators.clear();
    }

    public boolean isOutDated() {
        return this.upgraded != null;
    }

    public BankItemHandler getItemHandler(PickupMode pickupMode) {
        BankItemHandler itemHandler = new BankItemHandler(this.items, this.lockedSlots, this.type, pickupMode, this::markDirty);
        this.invalidators.add(itemHandler::invalidate);
        return itemHandler;
    }

    public Container getContainer() {
        return new BankContainer(this);
    }

    public void markDirty() {
        if (this.uuid != null) {
            this.updateLockedSlotsRevision();
            this.updateRevision();
            BankStateManager.markDirty();
        }
    }

    public int size() {
        return this.items.size();
    }

    public int getMaxCountPerStack() {
        return this.type.stackLimit;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public List<ItemStack> getBlockItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) continue;
            items.add(stack);
        }
        return items;
    }

    public ItemStack getSelectedItem(int selectedItemSlot) {
        List<ItemStack> items = this.getBlockItems();
        return items.isEmpty() ? ItemStack.EMPTY : items.get(Math.min(selectedItemSlot, items.size() - 1));
    }

    public ItemStack getRandomItem(Random random) {
        List<ItemStack> items = this.getBlockItems();
        return items.isEmpty() ? ItemStack.EMPTY : items.get(random.nextInt(items.size()));
    }

    public ItemStack chooseItemToPlace(BankOptions options, Random random, int selectedSlot) {
        return switch (options.buildMode()) {
            default -> throw new MatchException(null, null);
            case BuildMode.NONE_NORMAL, BuildMode.NONE_RANDOM -> ItemStack.EMPTY;
            case BuildMode.NORMAL -> this.getSelectedItem(selectedSlot);
            case BuildMode.RANDOM -> this.getRandomItem(random);
        };
    }

    @Nullable
    public ItemStack getLockedStack(int slotIndex) {
        return this.lockedSlots.get(slotIndex);
    }

    public void lockSlot(int slotIndex, ItemStack itemStack) {
        this.lockedSlots.put(slotIndex, itemStack.copyWithCount(1));
    }

    public void unlockSlot(int slotIndex) {
        this.lockedSlots.remove(slotIndex);
    }

    public Map<Integer, ItemStack> getLockedSlots() {
        return this.lockedSlots;
    }

    public short getLockedSlotsRevision() {
        return this.lockedSlotsRevision;
    }

    public void updateLockedSlotsRevision() {
        this.lockedSlotsRevision = (short)(this.lockedSlotsRevision + 1 & Short.MAX_VALUE);
    }

    public short getRevision() {
        return this.revision;
    }

    private void updateRevision() {
        this.revision = (short)(this.revision + 1 & Short.MAX_VALUE);
    }

    public static BankItemStorage createFromCodec(UUID uuid, BankType type, List<ItemStack> items, Map<Integer, ItemStack> lockedSlots, String dateCreated, UUID lastUsedByPlayerUuid, String lastUsedByPlayerName) {
        BankItemStorage bankItemStorage = new BankItemStorage(type, uuid);
        bankItemStorage.initializeItems();
        for (int i = 0; i < items.size(); ++i) {
            bankItemStorage.items.set(i, items.get(i));
        }
        for (int i : lockedSlots.keySet()) {
            bankItemStorage.lockSlot(i, lockedSlots.get(i));
        }
        bankItemStorage.dateCreated = LocalDateTime.parse(dateCreated);
        bankItemStorage.usedByPlayerUUID = lastUsedByPlayerUuid;
        bankItemStorage.usedByPlayerName = lastUsedByPlayerName;
        return bankItemStorage;
    }
}

