/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.command.BankTypeArgumentType;
import net.natte.bankstorage.container.BankItemStorage;

public class BankFilter {
    private final List<BankTypeArgumentType.BankType> bankTypeFilter = new ArrayList<BankTypeArgumentType.BankType>();
    private final List<UUID> playerFilter = new ArrayList<UUID>();
    private final List<Predicate<ItemStack>> itemFilter = new ArrayList<Predicate<ItemStack>>();

    public void clear() {
        this.clearType();
        this.clearPlayers();
        this.clearItems();
    }

    public void clearType() {
        this.bankTypeFilter.clear();
    }

    public void clearPlayers() {
        this.playerFilter.clear();
    }

    public void clearItems() {
        this.itemFilter.clear();
    }

    public void addPlayer(ServerPlayer player) {
        this.playerFilter.add(player.getUUID());
    }

    public void addType(BankTypeArgumentType.BankType bankType) {
        this.bankTypeFilter.add(bankType);
    }

    public void addItemPredicate(Predicate<ItemStack> itemStackPredicate) {
        this.itemFilter.add(itemStackPredicate);
    }

    public boolean matchesBank(BankItemStorage bankItemStorage) {
        return this.matchesType(bankItemStorage) && this.matchesPlayer(bankItemStorage) && this.matchesItems(bankItemStorage);
    }

    private boolean matchesType(BankItemStorage bankItemStorage) {
        if (this.bankTypeFilter.isEmpty()) {
            return true;
        }
        return this.bankTypeFilter.contains((Object)this.getBankType(bankItemStorage));
    }

    private BankTypeArgumentType.BankType getBankType(BankItemStorage bankItemStorage) {
        return switch (bankItemStorage.type().getName()) {
            case "bank_1" -> BankTypeArgumentType.BankType.BANK_1;
            case "bank_2" -> BankTypeArgumentType.BankType.BANK_2;
            case "bank_3" -> BankTypeArgumentType.BankType.BANK_3;
            case "bank_4" -> BankTypeArgumentType.BankType.BANK_4;
            case "bank_5" -> BankTypeArgumentType.BankType.BANK_5;
            case "bank_6" -> BankTypeArgumentType.BankType.BANK_6;
            case "bank_7" -> BankTypeArgumentType.BankType.BANK_7;
            default -> null;
        };
    }

    private boolean matchesPlayer(BankItemStorage bankItemStorage) {
        if (this.playerFilter.isEmpty()) {
            return true;
        }
        return this.playerFilter.contains(bankItemStorage.usedByPlayerUUID);
    }

    private boolean matchesItems(BankItemStorage bankItemStorage) {
        if (this.itemFilter.isEmpty()) {
            return true;
        }
        for (Predicate<ItemStack> predicate : this.itemFilter) {
            boolean hasMatchingStack = bankItemStorage.getItems().stream().anyMatch(predicate);
            if (hasMatchingStack) continue;
            return false;
        }
        return true;
    }
}

