/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.client.screen.BankScreen;
import net.natte.bankstorage.item.tooltip.BankTooltipData;
import net.natte.bankstorage.util.Util;

public class BankTooltipComponent
implements ClientTooltipComponent {
    public static final ResourceLocation TEXTURE = Util.ID("textures/gui/widgets.png");
    private final List<ItemStack> items;

    private BankTooltipComponent(List<ItemStack> items) {
        this.items = items;
    }

    public static BankTooltipComponent of(BankTooltipData tooltipData) {
        return new BankTooltipComponent(tooltipData.items());
    }

    private int getRows() {
        return (int)Math.ceil((double)this.items.size() / 9.0);
    }

    private int getColumns() {
        return Math.min(9, this.items.size());
    }

    public int getHeight() {
        return this.getRows() * 18 + 2 + 4;
    }

    public int getWidth(Font textRenderer) {
        return this.getColumns() * 18 + 2;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        this.drawBackground(context, x, y);
        int row = 0;
        int col = 0;
        for (ItemStack itemStack : this.items) {
            this.drawSlot(itemStack, context, textRenderer, x + col * 18 + 1, y + row * 18 + 1);
            if (++col != 9) continue;
            col = 0;
            ++row;
        }
    }

    private void drawBackground(GuiGraphics context, int x, int y) {
        int row = 0;
        int col = 0;
        for (ItemStack stack : this.items) {
            context.blit(TEXTURE, x + col * 18, y + row * 18, 20, 128, 20, 20);
            if (++col != 9) continue;
            col = 0;
            ++row;
        }
    }

    private void drawSlot(ItemStack itemStack, GuiGraphics context, Font textRenderer, int x, int y) {
        context.blit(TEXTURE, x, y, 1, 129, 18, 18);
        context.renderItem(itemStack, x + 1, y + 1);
        if (itemStack.getCount() > 1) {
            BankScreen.drawItemCount(context, textRenderer, itemStack.getCount(), x + 1, y + 1, false);
        }
        context.renderItemDecorations(textRenderer, itemStack.copyWithCount(1), x, y, null);
    }
}

