/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.screen;

import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.natte.bankstorage.util.Util;

public class ScrollBarWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    private static final ResourceLocation WIDGETS_TEXTURE = Util.ID("textures/gui/widgets.png");
    private final int x;
    private final int y;
    private final int totalRows;
    private final int visibleRows;
    private final int scrollBarHeight;
    private int scrollerY;
    private final Consumer<Float> onScroll;
    private boolean isScrolling = false;

    public ScrollBarWidget(int x, int y, int totalRows, int visibleRows, float initialValue, Consumer<Float> onScroll) {
        this.x = x;
        this.y = y;
        this.totalRows = totalRows;
        this.visibleRows = visibleRows;
        this.onScroll = onScroll;
        this.scrollBarHeight = this.visibleRows * 18;
        this.scrollerY = this.getPosition(initialValue);
    }

    private int getPosition(float value) {
        int scrollerMin = this.y + 26;
        int scrollerMax = this.y + 9 + this.scrollBarHeight;
        return Mth.clamp((int)((int)Mth.lerp((float)value, (float)scrollerMin, (float)scrollerMax)), (int)(this.y + 26), (int)(this.y + 9 + this.scrollBarHeight));
    }

    private float getValue(int position) {
        int scrollerMin = this.y + 26;
        int scrollerMax = this.y + 9 + this.scrollBarHeight;
        return Mth.inverseLerp((float)position, (float)scrollerMin, (float)scrollerMax);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blit(WIDGETS_TEXTURE, this.x, this.y - 2, 0.0f, 151.0f, 24, 20, 256, 256);
        guiGraphics.blit(WIDGETS_TEXTURE, this.x, this.y + 18, 24, this.scrollBarHeight - 2, 0.0f, 172.0f, 24, 8, 256, 256);
        guiGraphics.blit(WIDGETS_TEXTURE, this.x, this.y + 16 + this.scrollBarHeight, 0.0f, 181.0f, 24, 10, 256, 256);
        guiGraphics.blit(WIDGETS_TEXTURE, this.x + 2, this.scrollerY - 8, 0.0f, 192.0f, 12, 15, 256, 256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isOverScrollArea(mouseX, mouseY)) {
            this.isScrolling = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollerY = (int)Mth.clamp((double)mouseY, (double)(this.y + 26), (double)(this.y + 9 + this.scrollBarHeight));
            this.onScroll.accept(Float.valueOf(this.getValue(this.scrollerY)));
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isOverScrollArea(mouseX, mouseY)) {
            int hiddenRows = this.totalRows - this.visibleRows;
            int topRow = Mth.clamp((int)Math.round(this.getValue(this.scrollerY) * (float)hiddenRows), (int)0, (int)hiddenRows);
            topRow -= (int)scrollY;
            topRow = Mth.clamp((int)topRow, (int)0, (int)hiddenRows);
            this.scrollerY = this.getPosition((float)topRow / (float)hiddenRows);
            this.onScroll.accept(Float.valueOf(this.getValue(this.scrollerY)));
            return true;
        }
        return false;
    }

    public boolean isOverScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.x + 2) && mouseX <= (double)(this.x + 14) && mouseY >= (double)(this.y + 18) && mouseY <= (double)(this.y + 16 + this.scrollBarHeight);
    }

    public void setFocused(boolean focused) {
    }

    public boolean isFocused() {
        return false;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }
}

