/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.compat.rei;

import java.util.function.Predicate;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.Shapes;
import net.natte.bankstorage.client.screen.BankScreen;
import net.natte.bankstorage.inventory.BankSlot;
import net.natte.bankstorage.packet.server.LockSlotPacketC2S;
import net.natte.bankstorage.screen.BankScreenHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BankDraggableStackVisitor
implements DraggableStackVisitor<BankScreen> {
    public <R extends Screen> boolean isHandingScreen(R screen) {
        return screen instanceof BankScreen;
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<BankScreen> context, DraggableStack stack) {
        Slot slot = ((BankScreen)context.getScreen()).getSlotUnderMouse();
        if (!(slot instanceof BankSlot)) {
            return DraggedAcceptorResult.PASS;
        }
        BankSlot bankSlot = (BankSlot)slot;
        Object object = stack.getStack().getValue();
        if (!(object instanceof ItemStack)) {
            return DraggedAcceptorResult.PASS;
        }
        ItemStack draggedItem = (ItemStack)object;
        if (draggedItem.isEmpty()) {
            return DraggedAcceptorResult.PASS;
        }
        BankScreen screen = (BankScreen)context.getScreen();
        ((BankScreenHandler)screen.getMenu()).lockSlot(bankSlot.index, draggedItem);
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(((BankScreenHandler)screen.getMenu()).containerId, bankSlot.index, draggedItem, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return DraggedAcceptorResult.ACCEPTED;
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<BankScreen> context, DraggableStack stack) {
        Object object = stack.getStack().getValue();
        if (!(object instanceof ItemStack)) {
            return Stream.empty();
        }
        ItemStack draggedItem = (ItemStack)object;
        if (draggedItem.isEmpty()) {
            return Stream.empty();
        }
        BankScreen screen = (BankScreen)context.getScreen();
        int left = screen.getGuiLeft();
        int top = screen.getGuiTop();
        Predicate<Slot> hasBounds = slot -> {
            if (!slot.isActive()) return false;
            if (!(slot instanceof BankSlot)) return false;
            BankSlot bankSlot = (BankSlot)((Object)slot);
            if (slot.getItem().isEmpty()) return true;
            if (bankSlot.isLocked()) return false;
            if (!ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)draggedItem)) return false;
            return true;
        };
        return ((BankScreenHandler)screen.getMenu()).slots.stream().filter(BankSlot.class::isInstance).map(slot -> () -> hasBounds.test((Slot)slot) ? Shapes.box((double)(left + slot.x), (double)(top + slot.y), (double)0.0, (double)(left + slot.x + 16), (double)(top + slot.y + 16), (double)0.1) : Shapes.empty());
    }
}

