/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.natte.bankstorage.client.screen.BankScreen;
import net.natte.bankstorage.inventory.BankSlot;
import net.natte.bankstorage.packet.server.LockSlotPacketC2S;
import net.natte.bankstorage.screen.BankScreenHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BankDragDropHandler
implements EmiDragDropHandler<BankScreen> {
    public boolean dropStack(BankScreen screen, EmiIngredient ingredient, int x, int y) {
        Slot slot = screen.getSlotUnderMouse();
        if (!(slot instanceof BankSlot)) {
            return false;
        }
        BankSlot bankSlot = (BankSlot)slot;
        ItemStack draggedItem = ((EmiStack)ingredient.getEmiStacks().getFirst()).getItemStack();
        if (draggedItem.isEmpty()) {
            return false;
        }
        ((BankScreenHandler)screen.getMenu()).lockSlot(bankSlot.index, draggedItem);
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(((BankScreenHandler)screen.getMenu()).containerId, bankSlot.index, draggedItem, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public void render(BankScreen screen, EmiIngredient dragged, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        ItemStack draggedStack = ((EmiStack)dragged.getEmiStacks().getFirst()).getItemStack();
        if (draggedStack.isEmpty()) {
            return;
        }
        for (Slot slot : ((BankScreenHandler)screen.getMenu()).slots) {
            if (!slot.isActive() || !(slot instanceof BankSlot)) continue;
            BankSlot bankSlot = (BankSlot)slot;
            if (!slot.getItem().isEmpty() && (bankSlot.isLocked() || !ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)draggedStack))) continue;
            int x = screen.getGuiLeft() + slot.x;
            int y = screen.getGuiTop() + slot.y;
            guiGraphics.fill(x, y, x + 16, y + 16, -2010989773);
        }
    }
}

