/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.natte.bankstorage.BankStorage;
import net.natte.bankstorage.client.events.KeyBindUpdateEvents;
import net.natte.bankstorage.client.events.MouseEvents;
import net.natte.bankstorage.client.rendering.BankDockBlockEntityRenderer;
import net.natte.bankstorage.client.rendering.BuildModePreviewRenderer;
import net.natte.bankstorage.client.screen.BankScreen;
import net.natte.bankstorage.client.tooltip.BankTooltipComponent;
import net.natte.bankstorage.container.BankType;
import net.natte.bankstorage.container.CachedBankStorage;
import net.natte.bankstorage.item.tooltip.BankTooltipData;
import net.natte.bankstorage.packet.server.CycleBuildModePacketC2S;
import net.natte.bankstorage.packet.server.OpenBankFromKeyBindPacketC2S;
import net.natte.bankstorage.packet.server.PickupModePacketC2S;
import net.natte.bankstorage.packet.server.RequestBankStoragePacketC2S;
import net.natte.bankstorage.packet.server.ToggleBuildModePacketC2S;
import net.natte.bankstorage.util.Util;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="bankstorage", dist={Dist.CLIENT})
public class BankStorageClient {
    public static final KeyMapping toggleBuildModeKeyBinding = new KeyMapping("key.bankstorage.togglebuildmode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.bankstorage");
    public static final KeyMapping cycleBuildModeKeyBinding = new KeyMapping("key.bankstorage.cyclebuildmode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.bankstorage");
    public static final KeyMapping togglePickupModeKeyBinding = new KeyMapping("key.bankstorage.togglepickupmode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.bankstorage");
    public static final KeyMapping lockSlotKeyBinding = new KeyMapping("key.bankstorage.lockslot", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 342, "category.bankstorage");
    public static final KeyMapping openBankFromKeyBinding = new KeyMapping("key.bankstorage.openbankfromkeybind", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.bankstorage");
    public static final KeyMapping enableBlockSelectionScrollKeyBinding = new KeyMapping("key.bankstorage.enablescroll", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "category.bankstorage");
    public static final BuildModePreviewRenderer buildModePreviewRenderer = new BuildModePreviewRenderer();

    public BankStorageClient(IEventBus modBus) {
        this.registerHandledScreens(modBus);
        this.registerRenderers(modBus);
        this.registerEventListeners(modBus);
        modBus.addListener(this::registerModelPredicates);
        modBus.addListener(this::registerKeyBinds);
        modBus.addListener(this::initializeClientOnRenderThread);
        modBus.addListener(this::registerItemColors);
        NeoForge.EVENT_BUS.addListener(this::registerTickEvents);
        NeoForge.EVENT_BUS.addListener(MouseEvents::onScroll);
    }

    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (BankType type : BankStorage.BANK_TYPES) {
            event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)0), new ItemLike[]{(ItemLike)type.item.get()});
        }
        event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)0), new ItemLike[]{(ItemLike)BankStorage.BANK_LINK.get()});
    }

    private void registerEventListeners(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(event -> KeyBindUpdateEvents.onKeyBindChange());
        modBus.addListener(event -> event.register(BankTooltipData.class, BankTooltipComponent::of));
    }

    private void registerModelPredicates(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (BankType type : BankStorage.BANK_TYPES) {
                ItemProperties.register((Item)((Item)type.item.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"has_color"), (stack, level, entity, seed) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
            }
            ItemProperties.register((Item)((Item)BankStorage.BANK_LINK.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"has_color"), (stack, level, entity, seed) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
        });
    }

    private void registerRenderers(IEventBus modBus) {
        NeoForge.EVENT_BUS.addListener(event -> buildModePreviewRenderer.render(event.getGuiGraphics()));
        modBus.addListener(event -> event.registerBlockEntityRenderer((BlockEntityType)BankStorage.BANK_DOCK_BLOCK_ENTITY.get(), BankDockBlockEntityRenderer::new));
    }

    private void registerTickEvents(ClientTickEvent.Post event) {
        this.handleInputs();
        buildModePreviewRenderer.tick();
        this.sendQueuedUpdateRequests();
        CachedBankStorage.advanceThrottledQueue();
    }

    private void registerHandledScreens(IEventBus modBus) {
        modBus.addListener(event -> event.register(BankStorage.MENU_TYPE, BankScreen::new));
    }

    private void initializeClientOnRenderThread(FMLClientSetupEvent event) {
        event.enqueueWork(() -> Util.isClient.set(true));
    }

    public void registerKeyBinds(RegisterKeyMappingsEvent event) {
        event.register(toggleBuildModeKeyBinding);
        event.register(cycleBuildModeKeyBinding);
        event.register(togglePickupModeKeyBinding);
        event.register(lockSlotKeyBinding);
        event.register(openBankFromKeyBinding);
        event.register(enableBlockSelectionScrollKeyBinding);
    }

    public void handleInputs() {
        while (toggleBuildModeKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)ToggleBuildModePacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (cycleBuildModeKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)CycleBuildModePacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (togglePickupModeKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)PickupModePacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (openBankFromKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenBankFromKeyBindPacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void sendQueuedUpdateRequests() {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null || client.player == null) {
            return;
        }
        for (UUID uuid : CachedBankStorage.bankRequestQueue) {
            short cachedRevision = 0;
            CachedBankStorage storage = CachedBankStorage.getBankStorage(uuid);
            if (storage != null) {
                cachedRevision = storage.revision;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestBankStoragePacketC2S(uuid, cachedRevision), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        CachedBankStorage.bankRequestQueue.clear();
    }

    static {
        Util.isShiftDown = Screen::hasShiftDown;
        CachedBankStorage.setCacheUpdater(CachedBankStorage.bankRequestQueue::add);
    }
}

