/*
 * Decompiled with CFR 0.152.
 */
package net.natte.bankstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.natte.bankstorage.blockentity.BankDockBlockEntity;
import net.natte.bankstorage.container.BankItemStorage;
import net.natte.bankstorage.screen.BankScreenHandlerFactory;
import net.natte.bankstorage.util.Util;
import org.jetbrains.annotations.Nullable;

public class BankDockBlock
extends Block
implements EntityBlock {
    public BankDockBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BankDockBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BankDockBlockEntity) {
            BankDockBlockEntity bankDockBlockEntity = (BankDockBlockEntity)blockEntity;
            ItemStack stackInHand = player.getMainHandItem();
            if (bankDockBlockEntity.hasBank()) {
                if (stackInHand.isEmpty() && player.isShiftKeyDown()) {
                    ItemStack bankInDock = bankDockBlockEntity.pickUpBank();
                    bankInDock.setPopTime(5);
                    player.setItemInHand(InteractionHand.MAIN_HAND, bankInDock);
                    world.playSound(null, (Entity)player, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 1.4f + 2.0f);
                    return InteractionResult.FAIL;
                }
                if (Util.isBankLike(stackInHand)) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    ItemStack bankInDock = bankDockBlockEntity.pickUpBank();
                    bankInDock.setPopTime(5);
                    player.setItemInHand(InteractionHand.MAIN_HAND, bankInDock);
                    world.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.2f, 0.0f);
                    world.playSound(null, (Entity)player, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 1.4f + 2.0f);
                    bankDockBlockEntity.putBank(stackInHand);
                    return InteractionResult.SUCCESS;
                }
                if (!world.isClientSide) {
                    ItemStack bankItem = bankDockBlockEntity.getBank();
                    BankItemStorage bankItemStorage = Util.getBankItemStorage(bankItem);
                    if (bankItemStorage == null) {
                        return InteractionResult.FAIL;
                    }
                    BankScreenHandlerFactory screenHandlerFactory = new BankScreenHandlerFactory(bankItemStorage.type(), bankItemStorage, bankItem, -1, ContainerLevelAccess.create((Level)world, (BlockPos)pos));
                    player.openMenu((MenuProvider)screenHandlerFactory, screenHandlerFactory::writeScreenOpeningData);
                }
                return InteractionResult.SUCCESS;
            }
            if (Util.isBankLike(stackInHand)) {
                bankDockBlockEntity.putBank(player.getMainHandItem());
                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                world.playSound(null, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.2f, 0.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BankDockBlockEntity) {
            BankDockBlockEntity bankDockBlockEntity = (BankDockBlockEntity)blockEntity;
            Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)bankDockBlockEntity.getBank());
        }
        super.onRemove(state, world, pos, newState, moved);
    }
}

