/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.config.CommonConfig;
import de.ellpeck.actuallyadditions.mod.crafting.LiquidFuelRecipe;
import de.ellpeck.actuallyadditions.mod.inventory.ContainerOilGenerator;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityOilGenerator
extends TileEntityBase
implements ISharingEnergyProvider,
ISharingFluidHandler,
MenuProvider {
    public final CustomEnergyStorage storage = new CustomEnergyStorage(50000, 0, (Integer)CommonConfig.Machines.OIL_GENERATOR_TRANSFER.get());
    public final FluidTank tank = new FluidTank(this, 2000, fluid -> TileEntityOilGenerator.getRecipeForFluid(fluid) != null){

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };
    public int currentEnergyProduce;
    public int currentBurnTime;
    public int maxBurnTime;
    private int lastEnergy;
    private int lastTank;
    private int lastBurnTime;
    private int lastMaxBurnTime;
    private int lastEnergyProduce;
    private int lastCompare;
    public int fuelUsage;

    public TileEntityOilGenerator(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.OIL_GENERATOR.getTileEntityType(), pos, state);
    }

    private static RecipeHolder<LiquidFuelRecipe> getRecipeForFluid(FluidStack fluid) {
        if (fluid != null) {
            for (RecipeHolder<LiquidFuelRecipe> recipe : ActuallyAdditionsAPI.LIQUID_FUEL_RECIPES) {
                if (recipe == null || !((LiquidFuelRecipe)recipe.value()).matches(fluid)) continue;
                return recipe;
            }
        }
        return null;
    }

    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / this.maxBurnTime;
    }

    private RecipeHolder<LiquidFuelRecipe> getRecipeForCurrentFluid() {
        FluidStack stack = this.tank.getFluid();
        if (!stack.isEmpty()) {
            return TileEntityOilGenerator.getRecipeForFluid(stack);
        }
        return null;
    }

    @Override
    public void writeSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.putInt("BurnTime", this.currentBurnTime);
            compound.putInt("CurrentEnergy", this.currentEnergyProduce);
            compound.putInt("MaxBurnTime", this.maxBurnTime);
            compound.putInt("FuelUsage", this.fuelUsage);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(lookupProvider, compound);
        super.writeSyncableNBT(compound, lookupProvider, type);
    }

    @Override
    public void readSyncableNBT(CompoundTag compound, HolderLookup.Provider lookupProvider, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.getInt("BurnTime");
            this.currentEnergyProduce = compound.getInt("CurrentEnergy");
            this.maxBurnTime = compound.getInt("MaxBurnTime");
            this.fuelUsage = compound.getInt("FuelUsage");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(lookupProvider, compound);
        super.readSyncableNBT(compound, lookupProvider, type);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityOilGenerator) {
            TileEntityOilGenerator tile = (TileEntityOilGenerator)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityOilGenerator) {
            boolean flag;
            TileEntityOilGenerator tile = (TileEntityOilGenerator)t;
            tile.serverTick();
            boolean bl = flag = tile.currentBurnTime > 0;
            if (tile.currentBurnTime > 0 && tile.currentEnergyProduce > 0) {
                --tile.currentBurnTime;
                tile.storage.receiveEnergyInternal(tile.currentEnergyProduce, false);
            } else if (!tile.isRedstonePowered) {
                RecipeHolder<LiquidFuelRecipe> recipeHolder = tile.getRecipeForCurrentFluid();
                if (recipeHolder != null && tile.storage.getEnergyStored() < tile.storage.getMaxEnergyStored() && tile.tank.getFluidAmount() >= ((LiquidFuelRecipe)recipeHolder.value()).getFuelAmount()) {
                    LiquidFuelRecipe recipe = (LiquidFuelRecipe)recipeHolder.value();
                    tile.fuelUsage = recipe.getFuelAmount();
                    tile.currentEnergyProduce = recipe.getTotalEnergy() / recipe.getBurnTime();
                    tile.currentBurnTime = tile.maxBurnTime = recipe.getBurnTime();
                    tile.tank.getFluid().shrink(tile.fuelUsage);
                } else {
                    tile.currentEnergyProduce = 0;
                    tile.currentBurnTime = 0;
                    tile.maxBurnTime = 0;
                    tile.fuelUsage = 0;
                }
            }
            if (flag != tile.currentBurnTime > 0 || tile.lastCompare != tile.getComparatorStrength()) {
                tile.lastCompare = tile.getComparatorStrength();
                tile.setChanged();
            }
            if ((tile.storage.getEnergyStored() != tile.lastEnergy || tile.tank.getFluidAmount() != tile.lastTank || tile.lastBurnTime != tile.currentBurnTime || tile.lastEnergyProduce != tile.currentEnergyProduce || tile.lastMaxBurnTime != tile.maxBurnTime) && tile.sendUpdateWithInterval()) {
                tile.lastEnergy = tile.storage.getEnergyStored();
                tile.lastTank = tile.tank.getFluidAmount();
                tile.lastBurnTime = tile.currentBurnTime;
                tile.lastEnergyProduce = tile.currentEnergyProduce;
                tile.lastMaxBurnTime = tile.maxBurnTime;
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }

    @Override
    public IFluidHandler getFluidHandler(Direction facing) {
        return this.tank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public Direction[] getFluidShareSides() {
        return null;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        return this.storage;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.actuallyadditions.oilGenerator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new ContainerOilGenerator(windowId, playerInventory, this);
    }

    protected void applyImplicitComponents(@Nonnull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.storage.setEnergyStored((Integer)input.getOrDefault(ActuallyComponents.ENERGY_STORAGE, (Object)0));
        this.tank.setFluid(((ActuallyComponents.FluidContents)input.getOrDefault(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.EMPTY)).get());
    }

    protected void collectImplicitComponents(@Nonnull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ActuallyComponents.ENERGY_STORAGE, (Object)this.storage.getEnergyStored());
        builder.set(ActuallyComponents.FLUID_A, (Object)ActuallyComponents.FluidContents.of(this.tank.getFluid()));
    }
}

