/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree.nether;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.wood.MagmaLogBlock;

public class TallBrimWillowFeature
extends Feature<NoneFeatureConfiguration> {
    public TallBrimWillowFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.origin();
        WorldGenLevel level = context.level();
        int height = context.random().nextInt(3) + 13;
        if (level.getBlockState(pos.north()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.west()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.east()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.south()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.south().west()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.south().east()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.north().west()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.north().east()).getBlock() == RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma()) {
            return false;
        }
        if (level.getBlockState(pos.below()).getBlock() != RuBlocks.BRIMSPROUT_NYLIUM && level.getBlockState(pos.below()).getBlock() != Blocks.SCULK && !level.getBlockState(pos.below()).is(BlockTags.NYLIUM) && !level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            return false;
        }
        if (level.isEmptyBlock(pos)) {
            BlockPos.MutableBlockPos placePos = pos.mutable();
            for (int i = 0; i <= height; ++i) {
                if (i == 1) {
                    this.placeRoots((LevelAccessor)level, (BlockPos)placePos);
                }
                if (i == height - 3) {
                    this.placeBranches((LevelAccessor)level, (BlockPos)placePos);
                }
                if (i == height - 5) {
                    this.placeSpine((LevelAccessor)level, (BlockPos)placePos);
                }
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, (BlockPos)placePos)) {
                    if (level.isOutsideBuildHeight((BlockPos)placePos)) break;
                    if (i == 3) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma().defaultBlockState().setValue((Property)MagmaLogBlock.TRANSITION_BLOCK, (Comparable)Boolean.valueOf(true)), 2);
                    } else if (i < 3) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma().defaultBlockState().setValue((Property)MagmaLogBlock.TRANSITION_BLOCK, (Comparable)Boolean.valueOf(false)), 2);
                    } else if (i > 3) {
                        level.setBlock((BlockPos)placePos, (BlockState)RuBlocks.BRIMWOOD_WOOD_SET.getLog().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y), 2);
                    }
                }
                if (i == height) {
                    this.placeLeavesUpsideDown((LevelAccessor)level, (BlockPos)placePos);
                }
                placePos.move(Direction.UP);
            }
            return true;
        }
        return false;
    }

    private void placeBrimwoodLog(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)RuBlocks.BRIMWOOD_WOOD_SET.getLog().defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 2);
        }
    }

    private void placeBrimwoodLeaves(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, (BlockState)RuBlocks.BRIMWOOD_NATURAL_SET.getLeaves().defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    private void placeBranches(LevelAccessor level, BlockPos pos) {
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
                this.placeBrimwoodLog(level, pos.north(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north().north(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().above().north().north().north())) {
                this.placeBrimwoodLog(level, pos.north().above().north().north().north(), Direction.Axis.Z);
                this.placeLeavesUpsideDown(level, pos.north().above().north().north().north());
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
                this.placeBrimwoodLog(level, pos.south(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south().south(), Direction.Axis.Z);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().above().south().south().south())) {
                this.placeBrimwoodLog(level, pos.south().above().south().south().south(), Direction.Axis.Z);
                this.placeLeavesUpsideDown(level, pos.south().above().south().south().south());
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
                this.placeBrimwoodLog(level, pos.east(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east().east(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().above().east().east().east())) {
                this.placeBrimwoodLog(level, pos.east().above().east().east().east(), Direction.Axis.X);
                this.placeLeavesUpsideDown(level, pos.east().above().east().east().east());
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
                this.placeBrimwoodLog(level, pos.west(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west().west(), Direction.Axis.X);
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().above().west().west().west())) {
                this.placeBrimwoodLog(level, pos.west().above().west().west().west(), Direction.Axis.X);
                this.placeLeavesUpsideDown(level, pos.west().above().west().west().west());
            }
        }
    }

    private void placeBranchesGiant(LevelAccessor level, BlockPos pos) {
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            this.placeBrimwoodLog(level, pos.north(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north())) {
                this.placeBrimwoodLog(level, pos.north().north(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().north().above())) {
                    this.placeBrimwoodLog(level, pos.north().north().north().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().north().north().above())) {
                        this.placeBrimwoodLog(level, pos.north().north().north().north().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().north().north().above().north().above())) {
                            this.placeBrimwoodLog(level, pos.north().north().north().north().above().north().above(), Direction.Axis.Z);
                            this.placeLeavesUpsideDownGiant(level, pos.north().north().north().north().above().north().above());
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            this.placeBrimwoodLog(level, pos.south(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south())) {
                this.placeBrimwoodLog(level, pos.south().south(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().south().above())) {
                    this.placeBrimwoodLog(level, pos.south().south().south().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().south().south().above())) {
                        this.placeBrimwoodLog(level, pos.south().south().south().south().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().south().south().above().south().above())) {
                            this.placeBrimwoodLog(level, pos.south().south().south().south().above().south().above(), Direction.Axis.Z);
                            this.placeLeavesUpsideDownGiant(level, pos.south().south().south().south().above().south().above());
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            this.placeBrimwoodLog(level, pos.east(), Direction.Axis.X);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east())) {
                this.placeBrimwoodLog(level, pos.east().east(), Direction.Axis.X);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().east().above())) {
                    this.placeBrimwoodLog(level, pos.east().east().east().above(), Direction.Axis.X);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().east().east().above())) {
                        this.placeBrimwoodLog(level, pos.east().east().east().east().above(), Direction.Axis.X);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().east().east().above().east().above())) {
                            this.placeBrimwoodLog(level, pos.east().east().east().east().above().east().above(), Direction.Axis.X);
                            this.placeLeavesUpsideDownGiant(level, pos.east().east().east().east().above().east().above());
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            this.placeBrimwoodLog(level, pos.west(), Direction.Axis.X);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west())) {
                this.placeBrimwoodLog(level, pos.west().west(), Direction.Axis.X);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().west().above())) {
                    this.placeBrimwoodLog(level, pos.west().west().west().above(), Direction.Axis.X);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().west().west().above())) {
                        this.placeBrimwoodLog(level, pos.west().west().west().west().above(), Direction.Axis.X);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().west().west().above().west().above())) {
                            this.placeBrimwoodLog(level, pos.west().west().west().west().above().west().above(), Direction.Axis.X);
                            this.placeLeavesUpsideDownGiant(level, pos.west().west().west().west().above().west().above());
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west())) {
            this.placeBrimwoodLog(level, pos.north().west(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().north().west().above())) {
                this.placeBrimwoodLog(level, pos.north().west().north().west().above(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().north().west().north().west().above())) {
                    this.placeBrimwoodLog(level, pos.north().west().north().west().north().west().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().north().west().north().west().above().north().west().above())) {
                        this.placeBrimwoodLog(level, pos.north().west().north().west().north().west().above().north().west().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().north().west().north().west().above().north().west().above().north().west())) {
                            this.placeBrimwoodLog(level, pos.north().west().north().west().north().west().above().north().west().above().north().west(), Direction.Axis.Z);
                            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().north().west().north().west().above().north().west().above().north().west().above().north().west())) {
                                this.placeBrimwoodLog(level, pos.north().west().north().west().north().west().above().north().west().above().north().west().above().north().west(), Direction.Axis.Z);
                                this.placeLeavesUpsideDownGiant(level, pos.north().west().north().west().north().west().above().north().west().above().north().west().above().north().west());
                            }
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west())) {
            this.placeBrimwoodLog(level, pos.south().west(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().south().west().above())) {
                this.placeBrimwoodLog(level, pos.south().west().south().west().above(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().south().west().south().west().above())) {
                    this.placeBrimwoodLog(level, pos.south().west().south().west().south().west().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().south().west().south().west().above().south().west().above())) {
                        this.placeBrimwoodLog(level, pos.south().west().south().west().south().west().above().south().west().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().south().west().south().west().above().south().west().above().south().west())) {
                            this.placeBrimwoodLog(level, pos.south().west().south().west().south().west().above().south().west().above().south().west(), Direction.Axis.Z);
                            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().south().west().south().west().above().south().west().above().south().west().above().south().west())) {
                                this.placeBrimwoodLog(level, pos.south().west().south().west().south().west().above().south().west().above().south().west().above().south().west(), Direction.Axis.Z);
                                this.placeLeavesUpsideDownGiant(level, pos.south().west().south().west().south().west().above().south().west().above().south().west().above().south().west());
                            }
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east())) {
            this.placeBrimwoodLog(level, pos.north().east(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().north().east().above())) {
                this.placeBrimwoodLog(level, pos.north().east().north().east().above(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().north().east().north().east().above())) {
                    this.placeBrimwoodLog(level, pos.north().east().north().east().north().east().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().north().east().north().east().above().north().east().above())) {
                        this.placeBrimwoodLog(level, pos.north().east().north().east().north().east().above().north().east().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().north().east().north().east().above().north().east().above().north().east())) {
                            this.placeBrimwoodLog(level, pos.north().east().north().east().north().east().above().north().east().above().north().east(), Direction.Axis.Z);
                            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().north().east().north().east().above().north().east().above().north().east().above().north().east())) {
                                this.placeBrimwoodLog(level, pos.north().east().north().east().north().east().above().north().east().above().north().east().above().north().east(), Direction.Axis.Z);
                                this.placeLeavesUpsideDownGiant(level, pos.north().east().north().east().north().east().above().north().east().above().north().east().above().north().east());
                            }
                        }
                    }
                }
            }
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east())) {
            this.placeBrimwoodLog(level, pos.south().east(), Direction.Axis.Z);
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().south().east().above())) {
                this.placeBrimwoodLog(level, pos.south().east().south().east().above(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().south().east().south().east().above())) {
                    this.placeBrimwoodLog(level, pos.south().east().south().east().south().east().above(), Direction.Axis.Z);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().south().east().south().east().above().south().east().above())) {
                        this.placeBrimwoodLog(level, pos.south().east().south().east().south().east().above().south().east().above(), Direction.Axis.Z);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().south().east().south().east().above().south().east().above().south().east())) {
                            this.placeBrimwoodLog(level, pos.south().east().south().east().south().east().above().south().east().above().south().east(), Direction.Axis.Z);
                            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().south().east().south().east().above().south().east().above().south().east().above().south().east())) {
                                this.placeBrimwoodLog(level, pos.south().east().south().east().south().east().above().south().east().above().south().east().above().south().east(), Direction.Axis.Z);
                                this.placeLeavesUpsideDownGiant(level, pos.south().east().south().east().south().east().above().south().east().above().south().east().above().south().east());
                            }
                        }
                    }
                }
            }
        }
    }

    private void placeSpine(LevelAccessor level, BlockPos pos) {
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            this.placeBrimwoodLog(level, pos.north(), Direction.Axis.Z);
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            this.placeBrimwoodLog(level, pos.south(), Direction.Axis.Z);
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            this.placeBrimwoodLog(level, pos.east(), Direction.Axis.X);
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            this.placeBrimwoodLog(level, pos.west(), Direction.Axis.X);
        }
    }

    private void placeRoots(LevelAccessor level, BlockPos pos) {
        if (!level.isEmptyBlock(pos.north().below().north().below().below().below()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().north())) {
                this.placeBrimwoodLog(level, pos.north().north().north(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north())) {
                    // empty if block
                }
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().below().north())) {
                this.placeBrimwoodLog(level, pos.north().below().north(), Direction.Axis.Y);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().below().north().below())) {
                    this.placeBrimwoodLog(level, pos.north().below().north().below(), Direction.Axis.Y);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().below().north().below().below())) {
                        this.placeBrimwoodLog(level, pos.north().below().north().below().below(), Direction.Axis.Y);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().below().north().below().below().below())) {
                            this.placeBrimwoodLog(level, pos.north().below().north().below().below().below(), Direction.Axis.Y);
                        }
                    }
                }
            }
        }
        if (!level.isEmptyBlock(pos.south().below().south().below().below().below()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().south())) {
                this.placeBrimwoodLog(level, pos.south().south().south(), Direction.Axis.Z);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south())) {
                    // empty if block
                }
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().below().south())) {
                this.placeBrimwoodLog(level, pos.south().below().south(), Direction.Axis.Y);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().below().south().below())) {
                    this.placeBrimwoodLog(level, pos.south().below().south().below(), Direction.Axis.Y);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().below().south().below().below())) {
                        this.placeBrimwoodLog(level, pos.south().below().south().below().below(), Direction.Axis.Y);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().below().south().below().below().below())) {
                            this.placeBrimwoodLog(level, pos.south().below().south().below().below().below(), Direction.Axis.Y);
                        }
                    }
                }
            }
        }
        if (!level.isEmptyBlock(pos.east().below().east().below().below().below()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().east())) {
                this.placeBrimwoodLog(level, pos.east().east().east(), Direction.Axis.X);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east())) {
                    // empty if block
                }
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().below().east())) {
                this.placeBrimwoodLog(level, pos.east().below().east(), Direction.Axis.Y);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().below().east().below())) {
                    this.placeBrimwoodLog(level, pos.east().below().east().below(), Direction.Axis.Y);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().below().east().below().below())) {
                        this.placeBrimwoodLog(level, pos.east().below().east().below().below(), Direction.Axis.Y);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().below().east().below().below().below())) {
                            this.placeBrimwoodLog(level, pos.east().below().east().below().below().below(), Direction.Axis.Y);
                        }
                    }
                }
            }
        }
        if (!level.isEmptyBlock(pos.west().below().west().below().below().below()) && TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().west())) {
                this.placeBrimwoodLog(level, pos.west().west().west(), Direction.Axis.X);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west())) {
                    // empty if block
                }
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().below().west())) {
                this.placeBrimwoodLog(level, pos.west().below().west(), Direction.Axis.Y);
                if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().below().west().below())) {
                    this.placeBrimwoodLog(level, pos.west().below().west().below(), Direction.Axis.Y);
                    if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().below().west().below().below())) {
                        this.placeBrimwoodLog(level, pos.west().below().west().below().below(), Direction.Axis.Y);
                        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().below().west().below().below().below())) {
                            this.placeBrimwoodLog(level, pos.west().below().west().below().below().below(), Direction.Axis.Y);
                        }
                    }
                }
            }
        }
    }

    private void placeLeavesUpsideDown(LevelAccessor level, BlockPos pos) {
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            this.placeBrimwoodLeaves(level, pos);
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above())) {
            this.placeBrimwoodLeaves(level, pos.above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north())) {
            this.placeBrimwoodLeaves(level, pos.above().north());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north().east())) {
            this.placeBrimwoodLeaves(level, pos.above().north().east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().north().west())) {
            this.placeBrimwoodLeaves(level, pos.above().north().west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south())) {
            this.placeBrimwoodLeaves(level, pos.above().south());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south().east())) {
            this.placeBrimwoodLeaves(level, pos.above().south().east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().south().west())) {
            this.placeBrimwoodLeaves(level, pos.above().south().west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().east())) {
            this.placeBrimwoodLeaves(level, pos.above().east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.above().west())) {
            this.placeBrimwoodLeaves(level, pos.above().west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
            this.placeBrimwoodLeaves(level, pos.north());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().above());
            this.addVine(level, pos.north().north().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west())) {
            this.placeBrimwoodLeaves(level, pos.north().west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().west().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().west().above());
            this.addVine(level, pos.north().north().west().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.north().west().west().above());
            this.addVine(level, pos.north().west().west().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
            this.placeBrimwoodLeaves(level, pos.west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.west().west().above());
            this.addVine(level, pos.west().west().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west())) {
            this.placeBrimwoodLeaves(level, pos.south().west());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().west().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().west().above());
            this.addVine(level, pos.south().south().west().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().west().above())) {
            this.placeBrimwoodLeaves(level, pos.south().west().west().above());
            this.addVine(level, pos.south().west().west().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
            this.placeBrimwoodLeaves(level, pos.south());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().above());
            this.addVine(level, pos.south().south().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east())) {
            this.placeBrimwoodLeaves(level, pos.south().east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().east().above())) {
            this.placeBrimwoodLeaves(level, pos.south().south().east().above());
            this.addVine(level, pos.south().south().east().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.south().east().east().above());
            this.addVine(level, pos.south().east().east().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
            this.placeBrimwoodLeaves(level, pos.east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.east().east().above());
            this.addVine(level, pos.east().east().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east())) {
            this.placeBrimwoodLeaves(level, pos.north().east());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().east().above())) {
            this.placeBrimwoodLeaves(level, pos.north().north().east().above());
            this.addVine(level, pos.north().north().east().above());
        }
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().east().above())) {
            this.placeBrimwoodLeaves(level, pos.north().east().east().above());
            this.addVine(level, pos.north().east().east().above());
        }
    }

    private void placeLeavesUpsideDownGiant(LevelAccessor level, BlockPos pos) {
        BlockPos pos2 = pos.above();
        if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            this.placeBrimwoodLeaves(level, pos);
        }
        if (!level.isOutsideBuildHeight(pos)) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north())) {
                this.placeBrimwoodLeaves(level, pos.north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north())) {
                this.placeBrimwoodLeaves(level, pos.north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west())) {
                this.placeBrimwoodLeaves(level, pos.north().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().west())) {
                this.placeBrimwoodLeaves(level, pos.north().north().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().west().west())) {
                this.placeBrimwoodLeaves(level, pos.north().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west())) {
                this.placeBrimwoodLeaves(level, pos.west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.west().west())) {
                this.placeBrimwoodLeaves(level, pos.west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west())) {
                this.placeBrimwoodLeaves(level, pos.south().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().west())) {
                this.placeBrimwoodLeaves(level, pos.south().south().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().west().west())) {
                this.placeBrimwoodLeaves(level, pos.south().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south())) {
                this.placeBrimwoodLeaves(level, pos.south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south())) {
                this.placeBrimwoodLeaves(level, pos.south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east())) {
                this.placeBrimwoodLeaves(level, pos.south().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().south().east())) {
                this.placeBrimwoodLeaves(level, pos.south().south().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.south().east().east())) {
                this.placeBrimwoodLeaves(level, pos.south().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east())) {
                this.placeBrimwoodLeaves(level, pos.east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.east().east())) {
                this.placeBrimwoodLeaves(level, pos.east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east())) {
                this.placeBrimwoodLeaves(level, pos.north().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().north().east())) {
                this.placeBrimwoodLeaves(level, pos.north().north().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos.north().east().east())) {
                this.placeBrimwoodLeaves(level, pos.north().east().east());
            }
        }
        if (!level.isOutsideBuildHeight(pos2)) {
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north())) {
                this.placeBrimwoodLeaves(level, pos2.north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north())) {
                this.placeBrimwoodLeaves(level, pos2.north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().north())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().north());
                this.addVineGiant(level, pos2.north().north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().north().north().north())) {
                this.placeBrimwoodLeaves(level, pos2.east().north().north().north());
                this.addVineGiant(level, pos2.east().north().north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().east().north().north().north())) {
                this.placeBrimwoodLeaves(level, pos2.east().east().north().north().north());
                this.addVineGiant(level, pos2.east().east().north().north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().north().north().north())) {
                this.placeBrimwoodLeaves(level, pos2.west().north().north().north());
                this.addVineGiant(level, pos2.west().north().north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().west().north().north().north())) {
                this.placeBrimwoodLeaves(level, pos2.west().west().north().north().north());
                this.addVineGiant(level, pos2.west().west().north().north().north());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().west());
                this.addVineGiant(level, pos2.north().north().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().west().west());
                this.addVineGiant(level, pos2.north().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().west().west());
                this.addVineGiant(level, pos2.north().north().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west())) {
                this.placeBrimwoodLeaves(level, pos2.west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().west())) {
                this.placeBrimwoodLeaves(level, pos2.west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.west().west().west());
                this.addVineGiant(level, pos2.west().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().west().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().west().west().west());
                this.addVineGiant(level, pos2.south().west().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().west().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().west().west().west());
                this.addVineGiant(level, pos2.south().south().west().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().west().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().west().west().west());
                this.addVineGiant(level, pos2.north().west().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().west().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().west().west().west());
                this.addVineGiant(level, pos2.north().north().west().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().west());
                this.addVineGiant(level, pos2.south().south().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().west().west());
                this.addVineGiant(level, pos2.south().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().west().west())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().west().west());
                this.addVineGiant(level, pos2.south().south().west().west());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south())) {
                this.placeBrimwoodLeaves(level, pos2.south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south())) {
                this.placeBrimwoodLeaves(level, pos2.south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().south())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().south());
                this.addVineGiant(level, pos2.south().south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().south().south().south())) {
                this.placeBrimwoodLeaves(level, pos2.east().south().south().south());
                this.addVineGiant(level, pos2.east().south().south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().east().south().south().south())) {
                this.placeBrimwoodLeaves(level, pos2.east().east().south().south().south());
                this.addVineGiant(level, pos2.east().east().south().south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().south().south().south())) {
                this.placeBrimwoodLeaves(level, pos2.west().south().south().south());
                this.addVineGiant(level, pos2.west().south().south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.west().west().south().south().south())) {
                this.placeBrimwoodLeaves(level, pos2.west().west().south().south().south());
                this.addVineGiant(level, pos2.west().west().south().south().south());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().east());
                this.addVineGiant(level, pos2.south().south().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().east().east());
                this.addVineGiant(level, pos2.south().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().east().east());
                this.addVineGiant(level, pos2.south().south().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east())) {
                this.placeBrimwoodLeaves(level, pos2.east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().east())) {
                this.placeBrimwoodLeaves(level, pos2.east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.east().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.east().east().east());
                this.addVineGiant(level, pos2.east().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().east().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().east().east().east());
                this.addVineGiant(level, pos2.south().east().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.south().south().east().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.south().south().east().east().east());
                this.addVineGiant(level, pos2.south().south().east().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().east().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().east().east().east());
                this.addVineGiant(level, pos2.north().east().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().east().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().east().east().east());
                this.addVineGiant(level, pos2.north().north().east().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().east());
                this.addVineGiant(level, pos2.north().north().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().east().east());
                this.addVineGiant(level, pos2.north().east().east());
            }
            if (TallBrimWillowFeature.isReplaceable((LevelSimulatedReader)level, pos2.north().north().east().east())) {
                this.placeBrimwoodLeaves(level, pos2.north().north().east().east());
                this.addVineGiant(level, pos2.north().north().east().east());
            }
        }
    }

    private void addVine(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(3);
        BlockPos place = pos.above();
        for (int i = 0; i <= size; ++i) {
            if (TallBrimWillowFeature.isAir((LevelSimulatedReader)level, place)) {
                if (i == size) {
                    this.placeBrimwoodLeaves(level, place);
                } else {
                    this.placeBrimwoodLeaves(level, place);
                }
            } else {
                if (i == 0) break;
                this.placeBrimwoodLeaves(level, place.below());
                break;
            }
            place = place.above();
        }
    }

    private void addVineGiant(LevelAccessor level, BlockPos pos) {
        Random random = new Random();
        int size = random.nextInt(4);
        BlockPos place = pos.above();
        for (int i = 0; i <= size; ++i) {
            if (TallBrimWillowFeature.isAir((LevelSimulatedReader)level, place)) {
                if (i == size) {
                    this.placeBrimwoodLeaves(level, place);
                } else {
                    this.placeBrimwoodLeaves(level, place);
                }
            } else {
                if (i == 0) break;
                this.placeBrimwoodLeaves(level, place.below());
                break;
            }
            place = place.above();
        }
    }

    public static boolean isAirBlock(BlockState state) {
        return state.is(Blocks.AIR) || state.is(Blocks.CAVE_AIR) || state.is(Blocks.VOID_AIR);
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, TallBrimWillowFeature::isAirBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, TallBrimWillowFeature::isReplaceableBlock);
    }
}

