/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.branch.BranchBlock;
import net.regions_unexplored.world.level.block.wood.AspenLogBlock;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class AspenTreeFeature
extends Feature<RuTreeConfiguration> {
    public AspenTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (placeCheck == 0) {
                this.placeRoot((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main - 2) {
                this.placeStem((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            if (placeCheck == height_main) {
                this.placeBranches((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public boolean placeStem(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        int move = randomSource.nextInt(3) - 3;
        int rd = randomSource.nextInt(4);
        if (rd == 0 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.north()) && !level.isOutsideBuildHeight(pos.north())) {
            if (randomSource.nextInt(3) != 0) {
                this.placeLog(level, pos.north(), randomSource, treeConfiguration, Direction.Axis.Z);
            } else {
                level.setBlock(pos.north(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.NORTH), 2);
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlock(level, pos.north().above(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.north().north(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 1 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.south()) && !level.isOutsideBuildHeight(pos.south())) {
            if (randomSource.nextInt(3) != 0) {
                this.placeLog(level, pos.south(), randomSource, treeConfiguration, Direction.Axis.Z);
            } else {
                level.setBlock(pos.south(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.SOUTH), 2);
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlock(level, pos.south().above(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.south().south(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 2 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.east()) && !level.isOutsideBuildHeight(pos.east())) {
            if (randomSource.nextInt(3) != 0) {
                this.placeLog(level, pos.east(), randomSource, treeConfiguration, Direction.Axis.X);
            } else {
                level.setBlock(pos.east(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.EAST), 2);
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlock(level, pos.east().above(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.east().east(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.east().north(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.east().south(), randomSource, treeConfiguration);
                }
            }
        }
        if (rd == 3 && AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos.west()) && !level.isOutsideBuildHeight(pos.west())) {
            if (randomSource.nextInt(3) != 0) {
                this.placeLog(level, pos.west(), randomSource, treeConfiguration, Direction.Axis.X);
            } else {
                level.setBlock(pos.west(), (BlockState)treeConfiguration.branchProvider.getState(randomSource, pos).setValue((Property)BranchBlock.FACING, (Comparable)Direction.WEST), 2);
                if (randomSource.nextInt(2) == 0) {
                    this.placeLeavesBlock(level, pos.west().above(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.west().west(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.west().north(), randomSource, treeConfiguration);
                    this.placeLeavesBlock(level, pos.west().south(), randomSource, treeConfiguration);
                }
            }
        }
        return true;
    }

    public boolean placeBranches(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Direction.Axis axis;
        Direction direction;
        int type = randomSource.nextInt(3);
        BlockPos.MutableBlockPos placePos = pos.mutable();
        BlockPos.MutableBlockPos placePos2 = pos.mutable();
        int pickDirection = randomSource.nextInt(4);
        if (pickDirection == 0) {
            direction = Direction.NORTH;
            axis = Direction.Axis.Z;
        } else if (pickDirection == 1) {
            direction = Direction.SOUTH;
            axis = Direction.Axis.Z;
        } else if (pickDirection == 2) {
            direction = Direction.EAST;
            axis = Direction.Axis.X;
        } else {
            direction = Direction.WEST;
            axis = Direction.Axis.X;
        }
        if (type == 0) {
            int s = randomSource.nextInt(2);
            placePos2.move(direction.getOpposite());
            this.placeLog(level, (BlockPos)placePos2, randomSource, treeConfiguration, axis);
            this.placeLeavesBlob(level, (BlockPos)placePos2, randomSource, treeConfiguration);
            placePos.move(direction);
            placePos.move(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.move(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            if (s != 0) {
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            } else {
                placePos.move(Direction.UP);
                this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
                this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
        } else if (type == 1) {
            placePos.move(direction);
            placePos.move(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.move(Direction.UP);
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            this.placeLeavesBlob(level, (BlockPos)placePos, randomSource, treeConfiguration);
        } else {
            this.placeLeavesBlob(level, pos, randomSource, treeConfiguration);
        }
        return true;
    }

    public void placeRoot(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        int rd = random.nextInt(2) + 2;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (level.getBlockState((BlockPos)placePos).canBeReplaced() && level.getBlockState(placePos.above()).is(BlockTags.DIRT)) {
                level.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState(), 2);
                break;
            }
            if (!level.getBlockState((BlockPos)placePos).is(BlockTags.DIRT) && !level.getBlockState((BlockPos)placePos).is(BlockTags.REPLACEABLE_BY_TREES) && !level.isEmptyBlock((BlockPos)placePos)) break;
            this.placeLog(level, (BlockPos)placePos, randomSource, treeConfiguration, Direction.Axis.Y);
            placePos.move(Direction.DOWN);
        }
    }

    public boolean placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        this.placeLeavesBlock(level, pos, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.east().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.west().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos.above().above().above(), randomSource, treeConfiguration);
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.above().above().above().north(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.above().above().above().south(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.above().above().above().east(), randomSource, treeConfiguration);
        }
        if (random.nextInt(2) == 0) {
            this.placeLeavesBlock(level, pos.above().above().above().west(), randomSource, treeConfiguration);
        }
        return true;
    }

    public boolean placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration, Direction.Axis axis) {
        boolean isBase = false;
        if (level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            isBase = true;
        }
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.DIRT.defaultBlockState(), 2);
        } else if (AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            if (treeConfiguration.trunkProvider.getState(randomSource, pos).getBlock() instanceof AspenLogBlock) {
                level.setBlock(pos, (BlockState)((BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis)).setValue((Property)AspenLogBlock.IS_BASE, (Comparable)Boolean.valueOf(isBase)), 2);
            } else {
                level.setBlock(pos, (BlockState)treeConfiguration.trunkProvider.getState(randomSource, pos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis), 2);
            }
        } else {
            return true;
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.DIRT.defaultBlockState(), 2);
        }
        return true;
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return AspenTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, AspenTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, AspenTreeFeature::isReplaceableBlock);
    }
}

