/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.other_dirt;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;

public class AshenDirtBlock
extends Block {
    public static final BooleanProperty SMOULDERING = RuBlockStateProperties.SMOULDERING;

    public AshenDirtBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SMOULDERING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{SMOULDERING});
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getBlockState(pos.above()).is(Blocks.FIRE)) {
            level.setBlockAndUpdate(pos, (BlockState)RuBlocks.ASHEN_DIRT.get().defaultBlockState().setValue((Property)SMOULDERING, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state == RuBlocks.ASHEN_DIRT.get().defaultBlockState().setValue((Property)SMOULDERING, (Comparable)Boolean.valueOf(true))) {
            super.animateTick(state, level, pos, random);
            if (random.nextInt(20) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 1.1, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 1.1, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean isSmouldering(BlockState state) {
        return (Boolean)state.getValue((Property)SMOULDERING);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)SMOULDERING, (Comparable)Boolean.valueOf(false));
    }
}

