/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;

public class ChanceWillowTrunkDecorator
extends TreeDecorator {
    public static ChanceWillowTrunkDecorator INSTANCE = new ChanceWillowTrunkDecorator();
    public static final MapCodec<ChanceWillowTrunkDecorator> CODEC = MapCodec.unit(ChanceWillowTrunkDecorator::new);
    public static TreeDecoratorType<?> CHANCE_WILLOW_TRUNK_DECORATOR = new TreeDecoratorType(CODEC);

    protected TreeDecoratorType<?> type() {
        return CHANCE_WILLOW_TRUNK_DECORATOR;
    }

    public void place(TreeDecorator.Context context) {
        BlockPos newpos = (BlockPos)context.logs().get(0);
        if (context.level().isStateAtPosition(newpos, ChanceWillowTrunkDecorator::isGrass)) {
            newpos = newpos.above();
        }
        if (context.random().nextInt(2) == 0) {
            this.placeRoot(context, newpos.north());
            this.placeRoot(context, newpos.east());
            this.placeRoot(context, newpos.south());
            this.placeRoot(context, newpos.west());
            this.placeLog(context, newpos.north().above());
            this.placeLog(context, newpos.east().above());
            this.placeLog(context, newpos.south().above());
            this.placeLog(context, newpos.west().above());
            this.placeLog(context, newpos.north().above(2));
            this.placeLog(context, newpos.east().above(2));
            this.placeLog(context, newpos.south().above(2));
            this.placeLog(context, newpos.west().above(2));
        }
    }

    public void placeRoot(TreeDecorator.Context context, BlockPos pos) {
        LevelSimulatedReader level = context.level();
        Random random = new Random();
        int rd = random.nextInt(2) + 4;
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int i = 0; i <= rd; ++i) {
            if (ChanceWillowTrunkDecorator.isReplaceable(level, (BlockPos)placePos) && level.isStateAtPosition(placePos.above(), ChanceWillowTrunkDecorator::isDirt)) {
                context.setBlock((BlockPos)placePos, Blocks.HANGING_ROOTS.defaultBlockState());
                break;
            }
            this.placeLog(context, (BlockPos)placePos);
            placePos.move(Direction.DOWN);
        }
    }

    public void placeLog(TreeDecorator.Context context, BlockPos pos) {
        LevelSimulatedReader level = context.level();
        if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isForestGrass)) {
            context.setBlock(pos, RuBlocks.PEAT_DIRT.get().defaultBlockState());
        } else if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isPlainsGrass)) {
            context.setBlock(pos, RuBlocks.SILT_DIRT.get().defaultBlockState());
        } else if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isGrass)) {
            context.setBlock(pos, Blocks.DIRT.defaultBlockState());
        } else if (ChanceWillowTrunkDecorator.isReplaceable(level, pos)) {
            context.setBlock(pos, RuBlocks.WILLOW_WOOD_SET.getLog().defaultBlockState());
        } else {
            return;
        }
        if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isForestGrass)) {
            context.setBlock(pos.below(), RuBlocks.PEAT_DIRT.get().defaultBlockState());
        } else if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isPlainsGrass)) {
            context.setBlock(pos.below(), RuBlocks.SILT_DIRT.get().defaultBlockState());
        } else if (level.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isGrass)) {
            context.setBlock(pos.below(), Blocks.DIRT.defaultBlockState());
        }
    }

    public static boolean isGrass(BlockState state) {
        return state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.MYCELIUM) || state.is(Blocks.DIRT) || state.is(RuBlocks.ALPHA_GRASS_BLOCK.get());
    }

    public static boolean isForestGrass(BlockState state) {
        return state.is(RuBlocks.PEAT_GRASS_BLOCK.get()) || state.is(RuBlocks.PEAT_DIRT.get());
    }

    public static boolean isPlainsGrass(BlockState state) {
        return state.is(RuBlocks.SILT_GRASS_BLOCK.get()) || state.is(RuBlocks.SILT_DIRT.get());
    }

    public static boolean isDirt(BlockState state) {
        return state.is(BlockTags.DIRT);
    }

    public static boolean isAllGrass(BlockState state) {
        return state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.MYCELIUM) || state.is(Blocks.DIRT) || state.is(RuBlocks.PEAT_GRASS_BLOCK.get()) || state.is(RuBlocks.SILT_GRASS_BLOCK.get()) || state.is(RuBlocks.ALPHA_GRASS_BLOCK.get()) || state.is(RuBlocks.PEAT_DIRT.get()) || state.is(RuBlocks.SILT_DIRT.get());
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, ChanceWillowTrunkDecorator::isReplaceableBlock);
    }
}

