/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.registry;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.regions_unexplored.platform.Services;
import net.regions_unexplored.registry.ItemRegistry;
import net.regions_unexplored.world.level.block.wood.AspenLogBlock;
import net.regions_unexplored.world.level.block.wood.PineLogBlock;

public class BlockRegistry {
    public static Block block(float destroyTime, float explosionResistance, MapColor colour, SoundType sound, boolean fireproof, Function<BlockBehaviour.Properties, Block> factory) {
        return factory.apply(BlockRegistry.properties(destroyTime, explosionResistance, sound, fireproof, colour));
    }

    public static RotatedPillarBlock log(MapColor yColour, MapColor xzColour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 2.0f, sound, fireproof).mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? yColour : xzColour);
        return new RotatedPillarBlock(properties);
    }

    public static RotatedPillarBlock wood(MapColor colour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new RotatedPillarBlock(properties);
    }

    public static Block planks(MapColor colour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new Block(properties);
    }

    public static StairBlock stairs(MapColor colour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), properties);
    }

    public static SlabBlock slab(MapColor colour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new SlabBlock(properties);
    }

    public static DoorBlock door(MapColor colour, SoundType sound, BlockSetType blockSetType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(3.0f, 3.0f, sound, fireproof, colour).noOcclusion();
        return new DoorBlock(blockSetType, properties);
    }

    public static TrapDoorBlock trapdoor(MapColor colour, SoundType sound, BlockSetType blockSetType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(3.0f, 3.0f, sound, fireproof, colour).noOcclusion();
        return new TrapDoorBlock(blockSetType, properties);
    }

    public static FenceBlock fence(MapColor colour, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new FenceBlock(properties);
    }

    public static FenceGateBlock fenceGate(MapColor colour, WoodType type, SoundType sound, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(2.0f, 3.0f, sound, fireproof, colour);
        return new FenceGateBlock(type, properties);
    }

    public static PressurePlateBlock pressurePlate(MapColor colour, SoundType sound, BlockSetType blockSetType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(0.5f, 0.5f, sound, fireproof, colour).noCollission();
        return new PressurePlateBlock(blockSetType, properties);
    }

    public static ButtonBlock button(SoundType sound, BlockSetType blockSetType) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(0.5f, 0.5f, sound, true).noCollission();
        return new ButtonBlock(blockSetType, 30, properties);
    }

    public static StandingSignBlock sign(SoundType sound, WoodType woodType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(1.0f, 1.0f, sound, fireproof).noCollission();
        return new StandingSignBlock(woodType, properties);
    }

    public static WallSignBlock wallSign(SoundType sound, Block standingSign, WoodType woodType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(1.0f, 1.0f, sound, fireproof).noCollission().dropsLike(standingSign);
        return new WallSignBlock(woodType, properties);
    }

    public static CeilingHangingSignBlock hangingSign(MapColor color, SoundType sound, WoodType woodType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(1.0f, 1.0f, sound, fireproof, color).noCollission().forceSolidOn();
        return new CeilingHangingSignBlock(woodType, properties);
    }

    public static WallHangingSignBlock wallHangingSign(MapColor color, SoundType sound, Block hangingSign, WoodType woodType, boolean fireproof) {
        BlockBehaviour.Properties properties = BlockRegistry.properties(1.0f, 1.0f, sound, fireproof, color).noCollission().dropsLike(hangingSign).forceSolidOn();
        return new WallHangingSignBlock(woodType, properties);
    }

    private static BlockBehaviour.Properties properties(float destroyTime, float explosionResistance, SoundType sound, boolean fireproof) {
        return BlockRegistry.properties(destroyTime, explosionResistance, sound, fireproof, null);
    }

    private static BlockBehaviour.Properties properties(float destroyTime, float explosionResistance, SoundType sound, boolean fireproof, MapColor color) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(destroyTime, explosionResistance).sound(sound);
        if (!fireproof) {
            properties.ignitedByLava();
        }
        if (color != null) {
            properties.mapColor(color);
        }
        return properties;
    }

    public static Supplier<Block> registerDefaultBlock(String name, Supplier<Block> block) {
        Supplier<Block> toReturn = Services.REGISTAR.registerBlock(name, block);
        ItemRegistry.registerDefaultBlockItem(name, toReturn);
        return toReturn;
    }

    public static Supplier<Block> registerDefaultBlockNoItem(String name, Supplier<Block> block) {
        return Services.REGISTAR.registerBlock(name, block);
    }

    public static Supplier<Block> registerPlaceOnWaterBlock(String name, Supplier<Block> block) {
        Supplier<Block> toReturn = Services.REGISTAR.registerBlock(name, block);
        ItemRegistry.registerPlaceOnWaterItem(name, toReturn);
        return toReturn;
    }

    public static PineLogBlock pineLog(MapColor colour, MapColor colour2, SoundType sound) {
        return new PineLogBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava());
    }

    public static AspenLogBlock aspenLogBlock(MapColor colour, MapColor colour2, SoundType sound) {
        return new AspenLogBlock(BlockBehaviour.Properties.of().mapColor(p_152624_ -> p_152624_.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? colour : colour2).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(sound).ignitedByLava());
    }

    public static Block leaves(MapColor colour) {
        return BlockRegistry.leaves(colour, false, LeavesBlock::new);
    }

    public static Block leaves(MapColor colour, boolean fireproof, Function<BlockBehaviour.Properties, Block> factory) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(colour).strength(0.2f).randomTicks().sound(SoundType.GRASS).noOcclusion().isValidSpawn(BlockRegistry::ocelotOrParrot).isSuffocating(BlockRegistry::never).isViewBlocking(BlockRegistry::never).pushReaction(PushReaction.DESTROY).isRedstoneConductor(BlockRegistry::never);
        if (!fireproof) {
            properties.ignitedByLava();
        }
        return factory.apply(properties);
    }

    public static Boolean always(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return true;
    }

    public static boolean always(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public static Boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    public static Boolean ocelotOrParrot(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return type == EntityType.OCELOT || type == EntityType.PARROT;
    }
}

