/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen.provider;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.regions_unexplored.Constants;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.block.set.WoodSet;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.item.RuItems;

public class RuRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public static final Supplier<ImmutableList<ItemLike>> REDSTONE_SMELTABLES = Suppliers.memoize(() -> ImmutableList.of((Object)((ItemLike)RuBlocks.RAW_REDSTONE_BLOCK.get()), (Object)((ItemLike)RuBlocks.REDSTONE_BULB.get())));
    public static final Supplier<ImmutableList<ItemLike>> MOSSY_STONE_SMELTABLES = Suppliers.memoize(() -> ImmutableList.of((Object)Blocks.MOSSY_COBBLESTONE));

    public RuRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> holder) {
        super(output, holder);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PRISMOSS.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), (ItemLike)RuBlocks.PRISMOSS_SPROUT.get()).pattern("X").pattern("#").group("prismoss").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_PRISMOSS.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), (ItemLike)RuBlocks.PRISMOSS_SPROUT.get()).pattern("X").pattern("#").group("prismoss").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.HANGING_PRISMARITE.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()).pattern("#").pattern("#").pattern("#").group("prismarite").unlockedBy("has_prismarite", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.LARGE_PRISMARITE_CLUSTER.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()).pattern("#").pattern("#").group("prismarite").unlockedBy("has_prismarite", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PRISMARITE_CLUSTER.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PRISMAGLASS.get()), (int)2).define(Character.valueOf('#'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"glass"))).define(Character.valueOf('X'), RuTags.PRISMARITE_CRYSTALS_ITEM).pattern(" X ").pattern("X#X").pattern(" X ").group("stained_glass").unlockedBy("has_glass", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"glass")))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RuBlocks.RAW_REDSTONE_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Items.REDSTONE).pattern("##").pattern("##").group("redstone").unlockedBy("has_redstone", RuRecipeProvider.has((ItemLike)Items.REDSTONE)).save(consumer);
        RuRecipeProvider.oreSmelting(consumer, (List)REDSTONE_SMELTABLES.get(), RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, 200, "redstone");
        RuRecipeProvider.oreBlasting(consumer, (List)REDSTONE_SMELTABLES.get(), RecipeCategory.REDSTONE, (ItemLike)Items.REDSTONE, 0.7f, 100, "redstone");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)RuBlocks.REDSTONE_BUD.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Items.REDSTONE).pattern("###").group("redstone").unlockedBy("has_redstone", RuRecipeProvider.has((ItemLike)Items.REDSTONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.STONE_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.VIRIDESCENT_NYLIUM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.STONE).define(Character.valueOf('X'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms"))).pattern("X").pattern("#").group("viridescent_nylium").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).unlockedBy("has_mushroom", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms")))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DEEPSLATE).define(Character.valueOf('X'), TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms"))).pattern("X").pattern("#").group("viridescent_nylium").unlockedBy("has_deepslate", RuRecipeProvider.has((ItemLike)Blocks.DEEPSLATE)).unlockedBy("has_mushroom", RuRecipeProvider.has((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"mushrooms")))).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.DEAD_STEPPE_SHRUB.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.SMALL_DESERT_SHRUB.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.ALPHA_DANDELION.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.ALPHA_ROSE.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.BLEEDING_HEART.get(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuBlocks.BLUE_LUPINE.get(), "blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)RuBlocks.DAISY.get(), "light_gray_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLACK_DYE, (ItemLike)RuBlocks.DORCEL.get(), "black_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.FELICIA_DAISY.get(), "light_blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.FIREWEED.get(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.GLISTERING_BLOOM.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.HIBISCUS.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.MALLOW.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.HYSSOP.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_LUPINE.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.POPPY_BUSH.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.SALMON_POPPY_BUSH.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.PURPLE_LUPINE.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.RED_LUPINE.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.WARATAH.get(), "red_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)RuBlocks.WHITE_TRILLIUM.get(), "white_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.WILTING_TRILLIUM.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.YELLOW_LUPINE.get(), "yellow_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.RED_DYE, (ItemLike)RuBlocks.TSUBAKI.get(), "red_dye");
        for (Map.Entry<DyeColor, Block> entry : RuBlocks.SNOWBELLES.getMap().entrySet()) {
            RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)DyeItem.byColor((DyeColor)entry.getKey()), (ItemLike)entry.getValue(), entry.getKey().getName() + "_dye");
            RuRecipeProvider.snowbelle(consumer, (ItemLike)entry.getValue(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RuRecipeProvider.cId("dyes/" + entry.getKey().getName())));
        }
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.ORANGE_CONEFLOWER.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PURPLE_DYE, (ItemLike)RuBlocks.PURPLE_CONEFLOWER.get(), "purple_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.ASTER.get(), "light_blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_BLUE_DYE, (ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get(), "light_blue_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.BLUE_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getLeaves()).pattern("###").group("multiface_flowers").unlockedBy("has_blue_magnolia_leaves", RuRecipeProvider.has((ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getLeaves())).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get(), "pink_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.PINK_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getLeaves()).pattern("###").group("multiface_flowers").unlockedBy("has_pink_magnolia_leaves", RuRecipeProvider.has((ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getLeaves())).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.WHITE_DYE, (ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get(), "white_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.WHITE_MAGNOLIA_FLOWERS.get()), (int)6).define(Character.valueOf('#'), (ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getLeaves()).pattern("###").group("multiface_flowers").unlockedBy("has_white_magnolia_leaves", RuRecipeProvider.has((ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getLeaves())).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuItems.MEADOW_SAGE.get(), "blue_dye");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARLEY.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)200).unlockedBy("has_barley", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARLEY.get()))).save(consumer, Constants.id("barley_smelting"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARLEY.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)100).unlockedBy("has_barley", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARLEY.get()))).save(consumer, Constants.id("barley_smoking"));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BROWN_DYE, (ItemLike)RuBlocks.CATTAIL.get(), "brown_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIGHT_GRAY_DYE, (ItemLike)RuBlocks.TASSEL.get(), "light_gray_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.DAY_LILY.get(), "orange_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ASHEN_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.ASHEN_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.ACACIA_SAPLING, (ItemLike)RuBlocks.ACACIA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.BIRCH_SAPLING, (ItemLike)RuBlocks.BIRCH_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.CHERRY_SAPLING, (ItemLike)RuBlocks.CHERRY_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.MAGENTA_DYE, (ItemLike)RuBlocks.CACTUS_NATURAL_SET.getSapling(), "magenta_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.DARK_OAK_SAPLING, (ItemLike)RuBlocks.DARK_OAK_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.DEAD_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.DEAD_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.JUNGLE_SAPLING, (ItemLike)RuBlocks.JUNGLE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.LARCH_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.LARCH_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.MANGROVE_PROPAGULE, (ItemLike)RuBlocks.MANGROVE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.OAK_SAPLING, (ItemLike)RuBlocks.OAK_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PALM_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.PALM_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.PINE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Blocks.SPRUCE_SAPLING, (ItemLike)RuBlocks.SPRUCE_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getShrub(), "saplings", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getSapling(), (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getShrub(), "saplings", 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.ASHEN_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ASHEN_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_ashen_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.ASHEN_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.ACACIA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.ACACIA_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_acacia_sapling", RuRecipeProvider.has((ItemLike)Blocks.ACACIA_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_baobab_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.BIRCH_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.BIRCH_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_birch_sapling", RuRecipeProvider.has((ItemLike)Blocks.BIRCH_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_blackwood_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_brimwood_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.CHERRY_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.CHERRY_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_cherry_sapling", RuRecipeProvider.has((ItemLike)Blocks.CHERRY_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_magnolia_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_cypress_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.DARK_OAK_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.DARK_OAK_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dark_oak_sapling", RuRecipeProvider.has((ItemLike)Blocks.DARK_OAK_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dead_pine_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.DEAD_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.DEAD_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_dead_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.DEAD_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_eucalyptus_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_flowering_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_golden_larch_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_joshua_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_kapok_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.KAPOK_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.JUNGLE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.JUNGLE_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_jungle_sapling", RuRecipeProvider.has((ItemLike)Blocks.JUNGLE_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.LARCH_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.LARCH_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_larch_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.LARCH_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.MANGROVE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.MANGROVE_PROPAGULE).pattern("#").pattern("#").group("shrubs").unlockedBy("has_mangrove_propagule", RuRecipeProvider.has((ItemLike)Blocks.MANGROVE_PROPAGULE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_maple_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.MAPLE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_mauve_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.MAUVE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.OAK_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.OAK_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_oak_sapling", RuRecipeProvider.has((ItemLike)Blocks.OAK_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_orange_maple_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.PALM_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PALM_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_palm_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.PALM_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.PINE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_pine_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.PINE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_blue_magnolia_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_pink_magnolia_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_redwood_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_red_maple_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_enchanted_birch_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_silver_birch_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_socotra_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.SPRUCE_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)Blocks.SPRUCE_SAPLING).pattern("#").pattern("#").group("shrubs").unlockedBy("has_spruce_sapling", RuRecipeProvider.has((ItemLike)Blocks.SPRUCE_SAPLING)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_white_magnolia_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getShrub(), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getSapling()).pattern("#").pattern("#").group("shrubs").unlockedBy("has_willow_sapling", RuRecipeProvider.has((ItemLike)RuBlocks.WILLOW_NATURAL_SET.getSapling())).save(consumer);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.BLUE_DYE, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get(), "blue_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.LIME_DYE, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get(), "lime_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.PINK_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.PINK_DYE, (ItemLike)RuBlocks.PINK_BIOSHROOM.get(), "pink_dye");
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get(), (ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get(), "bioshrooms", 2);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.YELLOW_DYE, (ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get(), "yellow_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_blue_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_green_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_pink_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()).pattern("#").pattern("#").group("bioshrooms").unlockedBy("has_yellow_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.ICE).define(Character.valueOf('#'), (ItemLike)RuBlocks.ICICLE.get()).pattern("##").pattern("##").group("ice").unlockedBy("has_icicle", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.ICICLE.get()))).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)Blocks.ICE, (ItemLike)((ItemLike)RuBlocks.ICICLE.get()))));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.BARREL_CACTUS.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).group("cactus").unlockedBy("has_barrel_cactus", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BARREL_CACTUS.get()))).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)((ItemLike)RuBlocks.BARREL_CACTUS.get()))));
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.ORANGE_DYE, (ItemLike)RuBlocks.CAVE_HYSSOP.get(), "orange_dye");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_blue_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_blue_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLUE_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_green_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_green_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GREEN_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_pink_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_pink_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.PINK_BIOSHROOM_BLOCK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()).pattern("##").pattern("##").group("bioshroom_blocks").unlockedBy("has_yellow_bioshroom", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()).define(Character.valueOf('X'), (ItemLike)Blocks.GLOWSTONE).pattern(" # ").pattern("#X#").pattern(" # ").group("bioshroom_blocks").unlockedBy("has_yellow_bioshroom_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.YELLOW_BIOSHROOM_BLOCK.get()))).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.SAGUARO_CACTUS.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GREEN_DYE, (float)1.0f, (int)200).group("cactus").unlockedBy("has_saguaro_cactus", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.SAGUARO_CACTUS.get()))).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)Items.GREEN_DYE, (ItemLike)((ItemLike)RuBlocks.SAGUARO_CACTUS.get()))));
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.ACACIA_NATURAL_SET.getBranch(), (ItemLike)Blocks.ACACIA_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.ACACIA_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.BAOBAB_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BIRCH_NATURAL_SET.getBranch(), (ItemLike)Blocks.BIRCH_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BIRCH_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.BLACKWOOD_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.MAGNOLIA_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.CYPRESS_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.CHERRY_NATURAL_SET.getBranch(), (ItemLike)Blocks.CHERRY_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.CHERRY_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.DARK_OAK_NATURAL_SET.getBranch(), (ItemLike)Blocks.DARK_OAK_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.DARK_OAK_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.DEAD_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.DEAD_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.DEAD_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.EUCALYPTUS_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.JOSHUA_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.KAPOK_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.KAPOK_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.JUNGLE_NATURAL_SET.getBranch(), (ItemLike)Blocks.JUNGLE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.JUNGLE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.LARCH_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.LARCH_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.LARCH_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MANGROVE_NATURAL_SET.getBranch(), (ItemLike)Blocks.MANGROVE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MANGROVE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.MAPLE_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAPLE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.MAUVE_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.MAUVE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.OAK_NATURAL_SET.getBranch(), (ItemLike)Blocks.OAK_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.OAK_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.PALM_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.PALM_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.PALM_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.PINE_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.PINE_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.PINE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.REDWOOD_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.SILVER_BIRCH_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.SOCOTRA_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.SPRUCE_NATURAL_SET.getBranch(), (ItemLike)Blocks.SPRUCE_LOG);
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.SPRUCE_NATURAL_SET.getBranch(), "stick", 4);
        RuRecipeProvider.branchFromLog(consumer, (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getBranch(), (ItemLike)RuBlocks.WILLOW_WOOD_SET.getLog());
        RuRecipeProvider.oneToOneConversionRecipe(consumer, (ItemLike)Items.STICK, (ItemLike)RuBlocks.WILLOW_NATURAL_SET.getBranch(), "stick", 4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.PEAT_COARSE_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.PEAT_DIRT.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GRAVEL).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_gravel", RuRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.SILT_COARSE_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.SILT_DIRT.get()).define(Character.valueOf('G'), (ItemLike)Blocks.GRAVEL).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_gravel", RuRecipeProvider.has((ItemLike)Blocks.GRAVEL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)Blocks.DIRT).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)Blocks.DIRT)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.PEAT_DIRT.get()).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)((ItemLike)RuBlocks.PEAT_DIRT.get()))));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (int)4).define(Character.valueOf('D'), (ItemLike)RuBlocks.SILT_DIRT.get()).define(Character.valueOf('G'), RuTags.ASH_ITEM).pattern("DG").pattern("GD").group("coarse_dirt").unlockedBy("has_ash", RuRecipeProvider.has(RuTags.ASH_ITEM)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)((ItemLike)RuBlocks.ASHEN_DIRT.get()), (ItemLike)((ItemLike)RuBlocks.SILT_DIRT.get()))));
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK.get()})).group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_SLAB.get(), (ItemLike)RuBlocks.CHALK.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.CHALK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK.get()})).group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_STAIRS.get(), (ItemLike)RuBlocks.CHALK.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get()), (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).define(Character.valueOf('X'), RuTags.GRASS_ITEM).pattern("X").pattern("#").group("stone_grass").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.POLISHED_CHALK.get()).pattern("##").pattern("##").group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICKS.get(), (ItemLike)RuBlocks.CHALK_PILLAR.get());
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_BRICK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK_BRICKS.get()})).group("chalk").unlockedBy("has_chalk_bricks", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICK_SLAB.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.CHALK_BRICK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.CHALK_BRICKS.get()})).group("chalk").unlockedBy("has_chalk_bricks", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK_BRICKS.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_BRICK_STAIRS.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.CHALK_PILLAR.get()), (int)2).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).pattern("#").pattern("#").group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.CHALK_PILLAR.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()), (int)4).define(Character.valueOf('#'), (ItemLike)RuBlocks.CHALK.get()).pattern("##").pattern("##").group("chalk").unlockedBy("has_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_GRASS_BLOCK.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_BRICKS.get());
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK.get(), (ItemLike)RuBlocks.CHALK_PILLAR.get());
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK_SLAB.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.POLISHED_CHALK.get()})).group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK_SLAB.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get(), 2);
        RuRecipeProvider.stairBuilder((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK_STAIRS.get()), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RuBlocks.POLISHED_CHALK.get()})).group("chalk").unlockedBy("has_polished_chalk", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.POLISHED_CHALK.get()))).save(consumer);
        RuRecipeProvider.stonecutterResultFromBase(consumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.POLISHED_CHALK_STAIRS.get(), (ItemLike)RuBlocks.POLISHED_CHALK.get());
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.MOSSY_STONE.get()), (int)1).requires((ItemLike)Blocks.STONE).requires((ItemLike)Blocks.VINE).group("mossy").unlockedBy("has_stone", RuRecipeProvider.has((ItemLike)Blocks.STONE)).unlockedBy("has_vine", RuRecipeProvider.has((ItemLike)Blocks.VINE)).save(consumer);
        RuRecipeProvider.oreSmelting(consumer, (List)MOSSY_STONE_SMELTABLES.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.MOSSY_STONE.get(), 0.1f, 200, "mossy");
        RuRecipeProvider.oreBlasting(consumer, (List)MOSSY_STONE_SMELTABLES.get(), RecipeCategory.BUILDING_BLOCKS, (ItemLike)RuBlocks.MOSSY_STONE.get(), 0.1f, 100, "mossy");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)RuBlocks.HYACINTH_LAMP.get())).define(Character.valueOf('#'), (ItemLike)Items.PRISMARINE_SLAB).define(Character.valueOf('X'), RuTags.HYACINTH_BLOOMS_ITEM).pattern("X").pattern("#").group("hyacinth").unlockedBy("has_prismarine_slab", RuRecipeProvider.has((ItemLike)Items.PRISMARINE_SLAB)).unlockedBy("has_hyacinth", RuRecipeProvider.has(RuTags.HYACINTH_BLOOMS_ITEM)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.ASH.get()), (int)1).define(Character.valueOf('#'), (ItemLike)Items.GUNPOWDER).pattern("##").pattern("##").group("ash").unlockedBy("has_gunpowder", RuRecipeProvider.has((ItemLike)Items.GUNPOWDER)).save(consumer);
        RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)Blocks.BAMBOO_PLANKS, RuTags.BAMBOO_LOGS_ITEM, (int)4);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BAMBOO, (int)1).define(Character.valueOf('#'), RuTags.BAMBOO_LOGS_ITEM).pattern("#").pattern("#").group("bamboo").unlockedBy("has_bamboo_log", RuRecipeProvider.has(RuTags.BAMBOO_LOGS_ITEM)).save(consumer);
        RuRecipeProvider.woodenFence(consumer, (ItemLike)Items.OAK_FENCE, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenDoor(consumer, (ItemLike)Items.OAK_DOOR, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)Items.OAK_FENCE_GATE, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)Items.OAK_TRAPDOOR, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.pressurePlate(consumer, (ItemLike)Items.OAK_PRESSURE_PLATE, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenButton(consumer, (ItemLike)Items.OAK_BUTTON, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenSign(consumer, (ItemLike)Items.OAK_SIGN, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.hangingSign(consumer, (ItemLike)Items.OAK_HANGING_SIGN, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodenBoat(consumer, (ItemLike)Items.OAK_BOAT, (ItemLike)RuBlocks.ALPHA_WOOD_SET.getPlanks());
        RuRecipeProvider.woodFromOtherItem(consumer, (ItemLike)RuBlocks.BRIMWOOD_WOOD_SET.getWood(), (ItemLike)RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma());
        for (WoodSet woodSet : RuBlocks.WOOD_SETS) {
            if (woodSet.getWood() != null && woodSet.getLog() != null) {
                RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)woodSet.getWood(), (ItemLike)woodSet.getLog());
            }
            if (woodSet.getStrippedWood() != null && woodSet.getStrippedLog() != null) {
                RuRecipeProvider.woodFromLogs((RecipeOutput)consumer, (ItemLike)woodSet.getStrippedWood(), (ItemLike)woodSet.getStrippedLog());
            }
            if (woodSet.getPlanks() != null) {
                RuRecipeProvider.planksFromLogs((RecipeOutput)consumer, (ItemLike)woodSet.getPlanks(), RuTags.createItem(Constants.id(woodSet.getPlanks().builtInRegistryHolder().key().location().getPath().replace("_planks", "_logs"))), (int)4);
            }
            RuRecipeProvider.woodenStairs(consumer, (ItemLike)woodSet.getStairs(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenSlab(consumer, (ItemLike)woodSet.getSlab(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenFence(consumer, (ItemLike)woodSet.getFence(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenDoor(consumer, (ItemLike)woodSet.getDoor(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenFenceGate(consumer, (ItemLike)woodSet.getFenceGate(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenTrapdoor(consumer, (ItemLike)woodSet.getTrapdoor(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.pressurePlate(consumer, (ItemLike)woodSet.getPressurePlate(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenButton(consumer, (ItemLike)woodSet.getButton(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.woodenSign(consumer, (ItemLike)woodSet.getSign(), (ItemLike)woodSet.getPlanks());
            RuRecipeProvider.hangingSign(consumer, (ItemLike)woodSet.getHangingSign(), (ItemLike)woodSet.getStrippedLog());
            RuRecipeProvider.woodenBoat(consumer, (ItemLike)woodSet.getBoat(), (ItemLike)woodSet.getPlanks());
            if (woodSet.getChestBoat() == null || woodSet.getBoat() == null) continue;
            RuRecipeProvider.chestBoat((RecipeOutput)consumer, (ItemLike)woodSet.getChestBoat(), (ItemLike)woodSet.getBoat());
        }
        for (Map.Entry entry : RuBlocks.PAINTED_PLANKS.getMap().entrySet()) {
            RuRecipeProvider.paintedPlanks(consumer, (ItemLike)entry.getValue(), (TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)RuRecipeProvider.cId("dyes/" + ((DyeColor)entry.getKey()).getName())));
        }
        for (Map.Entry entry : RuBlocks.PAINTED_STAIRS.getMap().entrySet()) {
            RuRecipeProvider.paintedStairs(consumer, (ItemLike)entry.getValue(), (ItemLike)RuBlocks.PAINTED_PLANKS.getMap().get(entry.getKey()));
        }
        for (Map.Entry entry : RuBlocks.PAINTED_SLABS.getMap().entrySet()) {
            RuRecipeProvider.paintedSlab(consumer, (ItemLike)entry.getValue(), (ItemLike)RuBlocks.PAINTED_PLANKS.getMap().get(entry.getKey()));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()), (int)2).define(Character.valueOf('#'), (ItemLike)Blocks.BLACKSTONE).pattern("##").pattern("##").group("blackstone").unlockedBy("has_blackstone", RuRecipeProvider.has((ItemLike)Blocks.BLACKSTONE)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BLACKSTONE, (int)1).define(Character.valueOf('#'), (ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()).pattern("##").group("blackstone").unlockedBy("has_blackstone_cluster", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()))).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)Blocks.BLACKSTONE, (ItemLike)((ItemLike)RuBlocks.BLACKSTONE_CLUSTER.get()))));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()), (int)1).requires((ItemLike)Blocks.BONE_BLOCK).requires((ItemLike)RuBlocks.GLISTERING_NYLIUM.get()).group("overgrown_bone_block").unlockedBy("has_glistering_nylium", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.GLISTERING_NYLIUM.get()))).unlockedBy("has_bone_block", RuRecipeProvider.has((ItemLike)Blocks.BONE_BLOCK)).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BONE_MEAL, (int)9).requires((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()).group("bone_meal").unlockedBy("has_overgrown_bone_block", RuRecipeProvider.has((ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()))).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)Items.BONE_MEAL, (ItemLike)((ItemLike)RuBlocks.OVERGROWN_BONE_BLOCK.get()))));
    }

    private static ResourceLocation cId(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"c", (String)name);
    }

    public static Criterion<EnterBlockTrigger.TriggerInstance> insideOf(Block p_125980_) {
        return CriteriaTriggers.ENTER_BLOCK.createCriterion((CriterionTriggerInstance)new EnterBlockTrigger.TriggerInstance(Optional.empty(), Optional.of(p_125980_.builtInRegistryHolder()), Optional.empty()));
    }

    protected static void branchFromLog(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item, (int)2).define(Character.valueOf('#'), item2).define(Character.valueOf('X'), (ItemLike)Items.STICK).pattern("#X").group("branches").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }

    protected static void woodFromOtherItem(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (int)3).define(Character.valueOf('#'), item2).pattern("##").pattern("##").group("bark").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }

    protected static void paintedSlab(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("painted_slab").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void paintedStairs(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        RuRecipeProvider.stairBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("painted_stairs").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void paintedPlanks(RecipeOutput consumer, ItemLike result, TagKey<Item> dye) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)8).define(Character.valueOf('X'), dye).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("###").pattern("#X#").pattern("###").group("painted_planks").unlockedBy("has_planks", RuRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(consumer);
    }

    protected static void snowbelle(RecipeOutput consumer, ItemLike result, TagKey<Item> dye) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).requires(dye).requires(RuTags.SNOWBELLE_ITEM).group("snowbelle").unlockedBy("has_snowbelle", RuRecipeProvider.has(RuTags.SNOWBELLE_ITEM)).save(consumer);
    }

    protected static void planksFromOneLog(RecipeOutput p_259712_, ItemLike p_259052_, ItemLike p_259045_, int i) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)p_259052_, (int)i).requires(p_259045_).group("planks").unlockedBy("has_log", RuRecipeProvider.has((ItemLike)p_259045_)).save(p_259712_);
    }

    protected static void woodenButton(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.buttonBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_button").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenSign(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.signBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_sign").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void hangingSign(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item, (int)6).group("hanging_sign").define(Character.valueOf('#'), item2).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenBoat(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)item).define(Character.valueOf('#'), item2).pattern("# #").pattern("###").group("boat").unlockedBy("in_water", RuRecipeProvider.insideOf(Blocks.WATER)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenDoor(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.doorBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_door").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenFenceGate(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.fenceGateBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_fence_gate").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenFence(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.fenceBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_fence").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenSlab(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.slabBuilder((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_slab").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenStairs(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.stairBuilder((ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_stairs").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void woodenTrapdoor(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)item, (int)2).define(Character.valueOf('#'), item2).pattern("###").pattern("###").group("wooden_trapdoor").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void pressurePlate(RecipeOutput consumer, ItemLike item, ItemLike item2) {
        if (item == null || item2 == null) {
            return;
        }
        RuRecipeProvider.pressurePlateBuilder((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)item, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2})).group("wooden_pressure_plate").unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item)));
    }

    protected static void stonecutterResultFromBase(RecipeOutput consumer, RecipeCategory category, ItemLike item, ItemLike item2) {
        RuRecipeProvider.stonecutterResultFromBase(consumer, category, item, item2, 1);
    }

    protected static void stonecutterResultFromBase(RecipeOutput consumer, RecipeCategory category, ItemLike item, ItemLike item2, int i) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{item2}), (RecipeCategory)category, (ItemLike)item, (int)i).unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2) + "_stonecutting"));
    }

    protected static void oreSmelting(RecipeOutput consumer, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s) {
        RuRecipeProvider.oreCooking(consumer, RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, itemLikes, category, item, f, i, s, "_from_smelting");
    }

    protected static void oreBlasting(RecipeOutput consumer, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s) {
        RuRecipeProvider.oreCooking(consumer, RecipeSerializer.BLASTING_RECIPE, BlastingRecipe::new, itemLikes, category, item, f, i, s, "_from_blasting");
    }

    public static <T extends AbstractCookingRecipe> void oreCooking(RecipeOutput consumer, RecipeSerializer<T> serializer, AbstractCookingRecipe.Factory<T> factory, List<ItemLike> itemLikes, RecipeCategory category, ItemLike item, float f, int i, String s, String t) {
        for (ItemLike itemlike : itemLikes) {
            SimpleCookingRecipeBuilder.generic((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)category, (ItemLike)item, (float)f, (int)i, serializer, factory).group(s).unlockedBy(RuRecipeProvider.getHasName((ItemLike)itemlike), RuRecipeProvider.has((ItemLike)itemlike)).save(consumer, Constants.id(RuRecipeProvider.getItemName((ItemLike)item) + t + "_" + RuRecipeProvider.getItemName((ItemLike)itemlike)));
        }
    }

    protected static void oneToOneConversionRecipe(RecipeOutput consumer, ItemLike item, ItemLike item2, @Nullable String group) {
        RuRecipeProvider.oneToOneConversionRecipe(consumer, item, item2, group, 1);
    }

    protected static void oneToOneConversionRecipe(RecipeOutput consumer, ItemLike item, ItemLike item2, @Nullable String group, int ammount) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)item, (int)ammount).requires(item2).group(group).unlockedBy(RuRecipeProvider.getHasName((ItemLike)item2), RuRecipeProvider.has((ItemLike)item2)).save(consumer, Constants.id(RuRecipeProvider.getConversionRecipeName((ItemLike)item, (ItemLike)item2)));
    }
}

