/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.data.worldgen.features;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ClampedNormalFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.registry.ConfiguredFeatureRegistry;
import net.regions_unexplored.registry.FeatureRegistry;
import net.regions_unexplored.world.level.block.plant.flower.GroundCoverBlock;
import net.regions_unexplored.world.level.feature.configuration.LargePointedRedstoneConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneClusterConfiguration;
import net.regions_unexplored.world.level.feature.configuration.PointedRedstoneConfiguration;

public class RuNetherFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> SMALL_YELLOW_BIOSHROOM = ConfiguredFeatureRegistry.createKey("small_yellow_bioshroom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_MYCOTOXIC_MUSHROOMS = ConfiguredFeatureRegistry.createKey("patch_mycotoxic_mushrooms");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_MYCOTOXIC_GRASS = ConfiguredFeatureRegistry.createKey("patch_mycotoxic_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_MYCOTOXIC_DAISY = ConfiguredFeatureRegistry.createKey("patch_mycotoxic_daisy");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BRIMSPROUT = ConfiguredFeatureRegistry.createKey("patch_brimsprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BRIM_FLAMES = ConfiguredFeatureRegistry.createKey("patch_brim_flames");
    public static final ResourceKey<ConfiguredFeature<?, ?>> DORCEL = ConfiguredFeatureRegistry.createKey("dorcel");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRIMWOOD_SHRUB = ConfiguredFeatureRegistry.createKey("brimwood_shrub");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_ROCK = ConfiguredFeatureRegistry.createKey("nether_rock");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTERING_IVY = ConfiguredFeatureRegistry.createKey("patch_glistering_ivy");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTERING_SPROUT = ConfiguredFeatureRegistry.createKey("patch_glistering_sprout");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTERING_FERN = ConfiguredFeatureRegistry.createKey("patch_glistering_fern");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTERING_BLOOM = ConfiguredFeatureRegistry.createKey("patch_glistering_bloom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTER_SPIRE = ConfiguredFeatureRegistry.createKey("patch_glister_spire");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_GLISTER_BULB = ConfiguredFeatureRegistry.createKey("patch_glister_bulb");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_HANGING_EARLIGHT = ConfiguredFeatureRegistry.createKey("patch_hanging_earlight");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_COBALT_EARLIGHT = ConfiguredFeatureRegistry.createKey("patch_cobalt_earlight");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TALL_COBALT_EARLIGHT = ConfiguredFeatureRegistry.createKey("tall_cobalt_earlight");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_BLACKSTONE_CLUSTER = ConfiguredFeatureRegistry.createKey("patch_blackstone_cluster");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PATCH_COBALT_ROOTS = ConfiguredFeatureRegistry.createKey("patch_cobalt_roots");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OBSIDIAN_SPIRE = ConfiguredFeatureRegistry.createKey("obsidian_spire");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POINTED_REDSTONE_NETHER = ConfiguredFeatureRegistry.createKey("pointed_redstone_nether");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_POINTED_REDSTONE_NETHER = ConfiguredFeatureRegistry.createKey("large_pointed_redstone_nether");
    public static final ResourceKey<ConfiguredFeature<?, ?>> POINTED_REDSTONE_CLUSTER_NETHER = ConfiguredFeatureRegistry.createKey("pointed_redstone_cluster_nether");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MYCOTOXIC_NYLIUM_BONEMEAL = ConfiguredFeatureRegistry.createKey("mycotoxic_nylium_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLISTERING_NYLIUM_BONEMEAL = ConfiguredFeatureRegistry.createKey("glistering_nylium_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> COBALT_NYLIUM_BONEMEAL = ConfiguredFeatureRegistry.createKey("cobalt_nylium_bonemeal");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BRIMSPROUT_NYLIUM_BONEMEAL = ConfiguredFeatureRegistry.createKey("brimsprout_nylium_bonemeal");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        HolderGetter holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        SimpleWeightedRandomList.Builder mycotoxicMushroomsBuilder = SimpleWeightedRandomList.builder();
        SimpleWeightedRandomList.Builder mycotoxicBoneMealBlocks = SimpleWeightedRandomList.builder().add((Object)RuBlocks.MYCOTOXIC_GRASS.get().defaultBlockState(), 100).add((Object)RuBlocks.YELLOW_BIOSHROOM.get().defaultBlockState(), 7);
        SimpleWeightedRandomList.Builder glisteringBoneMealBlocks = SimpleWeightedRandomList.builder().add((Object)RuBlocks.GLISTERING_SPROUT.get().defaultBlockState(), 140).add((Object)RuBlocks.GLISTERING_BLOOM.get().defaultBlockState(), 30).add((Object)RuBlocks.GLISTERING_BLOOM.get().defaultBlockState(), 10);
        SimpleWeightedRandomList.Builder cobaltBoneMealBlocks = SimpleWeightedRandomList.builder().add((Object)RuBlocks.COBALT_ROOTS.get().defaultBlockState(), 100).add((Object)RuBlocks.COBALT_EARLIGHT.get().defaultBlockState(), 2);
        SimpleWeightedRandomList.Builder brimsproutBoneMealBlocks = SimpleWeightedRandomList.builder().add((Object)RuBlocks.BRIMSPROUT.get().defaultBlockState(), 140).add((Object)RuBlocks.DORCEL.get().defaultBlockState(), 1);
        for (int i = 1; i <= 4; ++i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mycotoxicMushroomsBuilder.add((Object)((BlockState)((BlockState)RuBlocks.MYCOTOXIC_MUSHROOMS.get().defaultBlockState().setValue((Property)GroundCoverBlock.AMOUNT, (Comparable)Integer.valueOf(i))).setValue((Property)GroundCoverBlock.FACING, (Comparable)direction)), 1);
            }
        }
        WeightedStateProvider mycotoxicWeights = new WeightedStateProvider(mycotoxicBoneMealBlocks);
        WeightedStateProvider glisteringWeights = new WeightedStateProvider(glisteringBoneMealBlocks);
        WeightedStateProvider cobaltWeights = new WeightedStateProvider(cobaltBoneMealBlocks);
        WeightedStateProvider brimsproutWeights = new WeightedStateProvider(brimsproutBoneMealBlocks);
        RuNetherFeatures.register(context, SMALL_YELLOW_BIOSHROOM, FeatureRegistry.SMALL_YELLOW_BIOSHROOM.get(), FeatureConfiguration.NONE);
        RuNetherFeatures.register(context, PATCH_MYCOTOXIC_MUSHROOMS, Feature.RANDOM_PATCH, new RandomPatchConfiguration(16, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(mycotoxicMushroomsBuilder)))));
        RuNetherFeatures.register(context, PATCH_MYCOTOXIC_GRASS, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.MYCOTOXIC_GRASS.get().defaultBlockState()), 32));
        RuNetherFeatures.register(context, PATCH_MYCOTOXIC_DAISY, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.MYCOTOXIC_DAISY.get().defaultBlockState()), 16));
        RuNetherFeatures.register(context, PATCH_BRIMSPROUT, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.BRIMSPROUT.get().defaultBlockState()), 32));
        RuNetherFeatures.register(context, PATCH_BRIM_FLAMES, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)Blocks.FIRE.defaultBlockState()), 12));
        RuNetherFeatures.register(context, DORCEL, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)RuBlocks.DORCEL.get())));
        RuNetherFeatures.register(context, BRIMWOOD_SHRUB, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)RuBlocks.BRIMWOOD_NATURAL_SET.getShrub())));
        RuNetherFeatures.register(context, NETHER_ROCK, FeatureRegistry.NETHER_ROCK.get(), FeatureConfiguration.NONE);
        RuNetherFeatures.register(context, PATCH_GLISTERING_IVY, FeatureRegistry.GLISTERING_IVY.get(), FeatureConfiguration.NONE);
        RuNetherFeatures.register(context, PATCH_GLISTERING_SPROUT, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GLISTERING_SPROUT.get().defaultBlockState()), 32));
        RuNetherFeatures.register(context, PATCH_GLISTERING_FERN, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GLISTERING_FERN.get().defaultBlockState())));
        RuNetherFeatures.register(context, PATCH_GLISTERING_BLOOM, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GLISTERING_BLOOM.get().defaultBlockState())));
        RuNetherFeatures.register(context, PATCH_GLISTER_SPIRE, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GLISTER_SPIRE.get().defaultBlockState()), 16));
        RuNetherFeatures.register(context, PATCH_GLISTER_BULB, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.GLISTER_BULB.get().defaultBlockState())));
        RuNetherFeatures.register(context, PATCH_HANGING_EARLIGHT, FeatureRegistry.HANGING_EARLIGHT.get(), FeatureConfiguration.NONE);
        RuNetherFeatures.register(context, PATCH_BLACKSTONE_CLUSTER, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.BLACKSTONE_CLUSTER.get().defaultBlockState()), 16));
        RuNetherFeatures.register(context, PATCH_COBALT_EARLIGHT, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.COBALT_EARLIGHT.get().defaultBlockState()), 6));
        RuNetherFeatures.register(context, TALL_COBALT_EARLIGHT, Feature.SIMPLE_BLOCK, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.TALL_COBALT_EARLIGHT.get().defaultBlockState())));
        RuNetherFeatures.register(context, PATCH_COBALT_ROOTS, Feature.RANDOM_PATCH, RuNetherFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((BlockState)RuBlocks.COBALT_ROOTS.get().defaultBlockState()), 32));
        RuNetherFeatures.register(context, OBSIDIAN_SPIRE, FeatureRegistry.OBSIDIAN_SPIRE.get(), FeatureConfiguration.NONE);
        RuNetherFeatures.register(context, POINTED_REDSTONE_NETHER, Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)FeatureRegistry.POINTED_REDSTONE.get(), (FeatureConfiguration)new PointedRedstoneConfiguration(0.5f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))}), PlacementUtils.inlinePlaced((Feature)FeatureRegistry.POINTED_REDSTONE.get(), (FeatureConfiguration)new PointedRedstoneConfiguration(0.5f, 0.7f, 0.5f, 0.5f), (PlacementModifier[])new PlacementModifier[]{EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))})})));
        RuNetherFeatures.register(context, LARGE_POINTED_REDSTONE_NETHER, FeatureRegistry.LARGE_POINTED_REDSTONE.get(), new LargePointedRedstoneConfiguration(30, (IntProvider)UniformInt.of((int)1, (int)6), (FloatProvider)UniformFloat.of((float)0.4f, (float)2.0f), 0.33f, (FloatProvider)UniformFloat.of((float)0.3f, (float)0.9f), (FloatProvider)UniformFloat.of((float)0.4f, (float)1.0f), (FloatProvider)UniformFloat.of((float)0.0f, (float)0.3f), 4, 0.6f));
        RuNetherFeatures.register(context, POINTED_REDSTONE_CLUSTER_NETHER, FeatureRegistry.POINTED_REDSTONE_CLUSTER.get(), new PointedRedstoneClusterConfiguration(12, (IntProvider)UniformInt.of((int)3, (int)6), (IntProvider)UniformInt.of((int)2, (int)8), 1, 3, (IntProvider)UniformInt.of((int)2, (int)4), (FloatProvider)UniformFloat.of((float)0.3f, (float)0.7f), (FloatProvider)ClampedNormalFloat.of((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), 0.1f, 3, 8));
        RuNetherFeatures.register(context, MYCOTOXIC_NYLIUM_BONEMEAL, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)mycotoxicWeights, 3, 1));
        RuNetherFeatures.register(context, GLISTERING_NYLIUM_BONEMEAL, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)glisteringWeights, 3, 1));
        RuNetherFeatures.register(context, COBALT_NYLIUM_BONEMEAL, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)cobaltWeights, 3, 1));
        RuNetherFeatures.register(context, BRIMSPROUT_NYLIUM_BONEMEAL, Feature.NETHER_FOREST_VEGETATION, new NetherForestVegetationConfig((BlockStateProvider)brimsproutWeights, 3, 1));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int i) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)i, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.register(key, (Object)new ConfiguredFeature(feature, config));
    }
}

