/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.util.StringUtil;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.client.gui.GuiProgrammer;
import vazkii.psi.client.patchouli.PatchouliUtils;

public class SpellGridComponent
implements ICustomComponent {
    public IVariable spell;
    private transient SpellGrid grid;
    private transient String spellName;

    public void build(int componentX, int componentY, int pageNum) {
        try {
            String spellstr = this.spell.asString("");
            if (StringUtil.isNullOrEmpty((String)spellstr)) {
                throw new IllegalArgumentException("Spell string is missing!");
            }
            CompoundTag cmp = TagParser.parseTag((String)spellstr);
            Spell fromNBT = Spell.createFromNBT(cmp);
            if (fromNBT == null) {
                throw new IllegalArgumentException("Invalid spell string: " + String.valueOf(this.spell));
            }
            this.grid = fromNBT.grid;
            this.spellName = fromNBT.name;
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid spell string: " + String.valueOf(this.spell), e);
        }
    }

    public void render(GuiGraphics graphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        float scale = 0.65f;
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, 0.0f);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(GuiProgrammer.texture, 0, 0, 0, 0, 174, 184);
        graphics.drawString(context.getGui().getMinecraft().font, I18n.get((String)"psimisc.name", (Object[])new Object[0]), 7, 171, 0xFFFFFF, true);
        graphics.drawString(context.getGui().getMinecraft().font, this.spellName, 44, 170, 0xFFFFFF, true);
        graphics.pose().translate(7.0f, 7.0f, 0.0f);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        this.grid.draw(graphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
        buffer.endBatch();
        float scaledSize = 18.0f * scale;
        int scaledHoverSize = (int)(16.0f * scale);
        SpellPiece[][] gridData = this.grid.gridData;
        for (int i = 0; i < gridData.length; ++i) {
            SpellPiece[] data = gridData[i];
            for (int j = 0; j < data.length; ++j) {
                SpellPiece piece = data[j];
                if (piece == null || !context.isAreaHovered(mouseX, mouseY, (int)(4.0f + (float)i * scaledSize), (int)(4.0f + (float)j * scaledSize), scaledHoverSize, scaledHoverSize)) continue;
                PatchouliUtils.setPieceTooltip(context, piece);
            }
        }
        graphics.pose().popPose();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        this.spell = (IVariable)lookup.apply(this.spell);
    }
}

