/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.random.RandomGenerator;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class WonderOfU
extends MoreRelicBase {
    public static boolean inDamageReflect = false;

    public WonderOfU(Item.Properties properties) {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"entropy").stat(StatData.builder((String)"perch").initialValue(7.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).ability(AbilityData.builder((String)"flow_of_calamity").stat(StatData.builder((String)"cooldown").initialValue(12.0, 8.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(5).build()).ability(AbilityData.builder((String)"event_horizon").stat(StatData.builder((String)"duration").initialValue(10.0, 14.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"cooldown").initialValue(540.0, 420.0).upgradeModifier(UpgradeOperation.ADD, -40.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(10).build()).build()).leveling(LevelingData.builder().maxLevel(13).initialCost(300).step(60).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"entropy").build()).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.level().isClientSide) {
            return;
        }
        IntegerCounter calamityCounter = DataComponentHandler.getAltIntegerCounter(stack);
        int calamityCooldown = calamityCounter.current();
        if (calamityCooldown >= 1) {
            --calamityCooldown;
        }
        stack.set(DataComponentHandler.ALT_INT_COUNTER, (Object)calamityCounter.getUpdatedCounter(calamityCooldown));
        MobEffectInstance nullEffect = livingEntity.getEffect(MoreRelics.NULLIFICATION);
        if (nullEffect != null && nullEffect.getDuration() == 1) {
            livingEntity.level().playSound(null, livingEntity.position().x, livingEntity.position().y, livingEntity.position().z, SoundEvents.BEACON_DEACTIVATE, SoundSource.MASTER, 1.0f, 0.5f);
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.level().isClientSide) {
            return;
        }
        if (ability.equals("event_horizon")) {
            MobEffectInstance nullification = new MobEffectInstance(MoreRelics.NULLIFICATION, (int)(this.getStatValue(stack, "event_horizon", "duration") * 20.0));
            player.addEffect(nullification);
            player.level().playSound(null, player.position().x, player.position().y, player.position().z, MoreRelics.WONDER, SoundSource.MASTER, 1.0f, 1.0f);
            this.horizonActivationBlast(player);
            this.setAbilityCooldown(stack, "event_horizon", (int)this.getStatValue(stack, "event_horizon", "cooldown") * 20);
        }
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (stack.getItem() != newStack.getItem() && livingEntity.hasEffect(MoreRelics.NULLIFICATION)) {
            livingEntity.removeEffect(MoreRelics.NULLIFICATION);
            livingEntity.level().playSound(null, livingEntity.position().x, livingEntity.position().y, livingEntity.position().z, SoundEvents.BEACON_DEACTIVATE, SoundSource.MASTER, 1.5f, 0.5f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void OnPlayerHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        boolean entityHasNullification = livingEntity.hasEffect(MoreRelics.NULLIFICATION);
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity applier = (LivingEntity)entity;
            if (!applier.level().isClientSide && livingEntity instanceof Player && (player = (Player)livingEntity) != applier) {
                int shouldApplyBadEffect;
                if (!inDamageReflect) {
                    inDamageReflect = true;
                    if (event.getAmount() < 0.5f) {
                        inDamageReflect = false;
                        return;
                    }
                    double reflectAmount = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WONDER_OF_U.get())).stream().mapToDouble(stack -> {
                        WonderOfU item = (WonderOfU)stack.getItem();
                        if (!item.isAbilityUnlocked((ItemStack)stack, "entropy")) {
                            return 0.0;
                        }
                        item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 5);
                        return (double)event.getAmount() * (item.getStatValue((ItemStack)stack, "entropy", "perch") / 100.0);
                    }).sum();
                    if (reflectAmount > 0.0) {
                        if (entityHasNullification) {
                            reflectAmount *= 2.0;
                        }
                        reflectAmount = Math.clamp(reflectAmount, 0.0, (double)player.getHealth());
                        applier.hurt(new DamageSource(livingEntity.damageSources().thorns((Entity)livingEntity).typeHolder(), (Entity)player, (Entity)player), (float)reflectAmount);
                    }
                    inDamageReflect = false;
                }
                if ((shouldApplyBadEffect = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WONDER_OF_U.get())).stream().mapToInt(stack -> {
                    WonderOfU item = (WonderOfU)stack.getItem();
                    if (!item.isAbilityUnlocked((ItemStack)stack, "flow_of_calamity")) {
                        return 0;
                    }
                    IntegerCounter calamityCounter = DataComponentHandler.getAltIntegerCounter(stack);
                    int calamityCooldown = calamityCounter.current();
                    if (calamityCooldown <= 0) {
                        stack.set(DataComponentHandler.ALT_INT_COUNTER, (Object)calamityCounter.getUpdatedCounter((int)(20.0 * item.getStatValue((ItemStack)stack, "flow_of_calamity", "cooldown"))));
                        return 1;
                    }
                    return 0;
                }).sum()) >= 1) {
                    WonderOfU.applyCalamity(applier);
                    if (entityHasNullification) {
                        WonderOfU.applyCalamity(applier);
                    }
                }
            }
        }
        if (entityHasNullification) {
            event.setCanceled(true);
        }
    }

    private static void applyCalamity(LivingEntity target) {
        Map<Holder<MobEffect>, Integer[]> calamityEffects = WonderOfU.getCalamityEffects();
        ArrayList<Map.Entry<Holder<MobEffect>, Integer[]>> effectList = new ArrayList<Map.Entry<Holder<MobEffect>, Integer[]>>(calamityEffects.entrySet());
        Collections.shuffle(effectList, RandomGenerator.getDefault());
        for (Map.Entry entry : effectList) {
            Holder effectType = (Holder)entry.getKey();
            Integer[] data = (Integer[])entry.getValue();
            int duration = data[0];
            int amplifier = data[1];
            if (target.hasEffect(effectType)) continue;
            target.addEffect(new MobEffectInstance(effectType, duration, amplifier));
            break;
        }
    }

    private void horizonActivationBlast(Player player) {
        Vec3 center = player.position();
        float radius = 4.0f;
        WonderOfU.spawnWonderExplosionParticles(player.level(), player.position(), radius);
        AABB area = new AABB(center.x - (double)radius, center.y - (double)radius, center.z - (double)radius, center.x + (double)radius, center.y + (double)radius, center.z + (double)radius);
        List detectedEntities = player.level().getEntities((Entity)player, area);
        for (Entity detected : detectedEntities) {
            if (!(detected instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)detected;
            if (player == detected) continue;
            Vec3 direction = livingEntity.position().subtract(center).normalize();
            double pushStrength = Math.clamp(3.0 / livingEntity.position().distanceTo(center), 1.0, 2.0);
            MobEffectInstance stun = new MobEffectInstance((Holder)EffectRegistry.STUN, 60);
            livingEntity.addEffect(stun);
            livingEntity.setDeltaMovement(livingEntity.getDeltaMovement().add(direction.scale(pushStrength)));
        }
    }

    private static Map<Holder<MobEffect>, Integer[]> getCalamityEffects() {
        HashMap<Holder<MobEffect>, Integer[]> effects = new HashMap<Holder<MobEffect>, Integer[]>();
        effects.put(MobEffects.MOVEMENT_SLOWDOWN, new Integer[]{100, 0});
        effects.put(MobEffects.WEAKNESS, new Integer[]{80, 0});
        effects.put(MobEffects.BLINDNESS, new Integer[]{40, 0});
        effects.put(MobEffects.DARKNESS, new Integer[]{120, 0});
        effects.put(MobEffects.HUNGER, new Integer[]{200, 1});
        effects.put(MobEffects.POISON, new Integer[]{100, 1});
        effects.put(MobEffects.WITHER, new Integer[]{80, 0});
        effects.put(MobEffects.UNLUCK, new Integer[]{180, 9});
        effects.put((Holder<MobEffect>)EffectRegistry.STUN, new Integer[]{20, 0});
        effects.put((Holder<MobEffect>)EffectRegistry.PARALYSIS, new Integer[]{40, 0});
        effects.put((Holder<MobEffect>)EffectRegistry.ANTI_HEAL, new Integer[]{200, 0});
        effects.put(MoreRelics.CORROSION, new Integer[]{80, 4});
        effects.put(MoreRelics.VULNERABILITY, new Integer[]{240, 0});
        return effects;
    }

    public static void spawnWonderExplosionParticles(Level level, Vec3 position, float radius) {
        int particleCount = 240;
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.players();
        for (int i = 0; i < particleCount; ++i) {
            double theta = Math.random() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * Math.random() - 1.0);
            double r = Math.cbrt(Math.random()) * (double)radius;
            double x = position.x + r * Math.sin(phi) * Math.cos(theta);
            double y = position.y + r * Math.cos(phi);
            double z = position.z + r * Math.sin(phi) * Math.sin(theta);
            for (ServerPlayer player : players) {
                sevLevel.sendParticles(player, (ParticleOptions)MoreRelics.WONDER_EXPLOSION.get(), true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

