/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.LocationHolder;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class WhimsOfFate
extends MoreRelicBase {
    public WhimsOfFate(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"just_one_more").stat(StatData.builder((String)"damage_reduction_per").initialValue(0.5, 1.0).upgradeModifier(UpgradeOperation.ADD, (double)0.1f).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(8).requiredPoints(1).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(8).initialCost(100).step(25).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"just_one_more").build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.DESERT, LootEntries.BASTION}).build()).build();
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingDamageEvent.Pre event) {
        Player player;
        block14: {
            block13: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block13;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block14;
            }
            return;
        }
        int highestRoll = 0;
        double highestReductionPer = 0.0;
        Random rand = new Random();
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.WHIMS_OF_FATE.get()))) {
            double reductionPer;
            WhimsOfFate item = (WhimsOfFate)stack.getItem();
            if (!item.isAbilityUnlocked(stack, "just_one_more")) continue;
            item.spreadRelicExperience((LivingEntity)player, stack, 2);
            int diceRoll = rand.nextInt(20) + 1;
            if (diceRoll > highestRoll) {
                highestRoll = diceRoll;
            }
            LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
            holder.x = diceRoll;
            if (diceRoll == 20) {
                holder.y += 1.0;
            } else if (diceRoll == 1) {
                holder.z += 1.0;
            }
            if (!((reductionPer = item.getStatValue(stack, "just_one_more", "damage_reduction_per")) > highestReductionPer)) continue;
            highestReductionPer = reductionPer;
        }
        if (highestRoll == 0) {
            return;
        }
        if (highestRoll == 1) {
            message = Component.translatable((String)"action.morerelics.roll1").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF0000))).withStyle(ChatFormatting.BOLD);
            player.displayClientMessage((Component)message, true);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WITHER_HURT, SoundSource.MASTER, 0.3f, 0.6f);
            event.setNewDamage(event.getNewDamage() * 2.0f);
        } else if (highestRoll == 20) {
            message = Component.translatable((String)"action.morerelics.roll20").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-16711936))).withStyle(ChatFormatting.BOLD);
            player.displayClientMessage((Component)message, true);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.MASTER, 0.3f, 1.2f);
            event.setNewDamage(0.0f);
        } else {
            event.setNewDamage((float)((double)event.getNewDamage() * (100.0 - (double)highestRoll * highestReductionPer) / 100.0));
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
        if (holder.x != 0.0) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.last_roll", (Object[])new Object[]{(int)holder.x}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
        if (holder.y != 0.0) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.20count", (Object[])new Object[]{(int)holder.y}).withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.ITALIC));
        }
        if (holder.z != 0.0) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.1count", (Object[])new Object[]{(int)holder.z}).withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
        }
        return list;
    }
}

