/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.relics.CyberwareBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class VertebraX
extends CyberwareBase {
    public static boolean currentlyInPotionEvent = false;

    public VertebraX(Item.Properties properties) {
        super(properties);
    }

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"inoculation").maxLevel(0).requiredLevel(0).build()).ability(AbilityData.builder((String)"fortification").stat(StatData.builder((String)"reduction").initialValue(12.0, 20.0).upgradeModifier(UpgradeOperation.ADD, 4.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"increase").initialValue(25.0, 35.0).upgradeModifier(UpgradeOperation.ADD, 5.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(3).build()).ability(AbilityData.builder((String)"acquired_immunity").maxLevel(0).requiredLevel(5).build()).ability(AbilityData.builder((String)"cyberpsychosis").stat(StatData.builder((String)"chance").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"duration").initialValue(4.0, 7.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).requiredLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(8).initialCost(120).step(30).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"inoculation").build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.THE_END}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().level().isClientSide) {
            return;
        }
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int poisonApplyCounter = counter.current();
        if (poisonApplyCounter > 0) {
            --poisonApplyCounter;
        } else {
            if (this.isAbilityUnlocked(stack, "inoculation")) {
                MobEffectInstance poisonEffect = new MobEffectInstance(MobEffects.POISON, 100);
                slotContext.entity().addEffect(poisonEffect);
                this.spreadRelicExperience(null, stack, 1);
            }
            poisonApplyCounter = 50;
        }
        stack.set(DataComponentHandler.INT_COUNTER, (Object)counter.getUpdatedCounter(poisonApplyCounter));
    }

    @SubscribeEvent
    public static void EffectAppliedEvent(MobEffectEvent.Applicable event) {
        Player player;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block4;
                player = (Player)livingEntity;
                if (!player.level().isClientSide && !currentlyInPotionEvent) break block5;
            }
            return;
        }
        currentlyInPotionEvent = true;
        float[] reductionAmount = new float[]{0.0f};
        float[] increaseAmount = new float[]{0.0f};
        boolean[] canTransformPoison = new boolean[]{false};
        EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.VERTEBRAX.get())).forEach(stack -> {
            boolean hasCyber;
            VertebraX item = (VertebraX)stack.getItem();
            boolean bl = hasCyber = player.hasEffect(MoreRelics.CYBERPSYCHOSIS.getDelegate());
            if (item.isAbilityUnlocked((ItemStack)stack, "fortification")) {
                reductionAmount[0] = reductionAmount[0] + (float)item.getStatValue((ItemStack)stack, "fortification", "reduction") * ((float)hasCyber * 0.5f + 1.0f);
                increaseAmount[0] = increaseAmount[0] + (float)item.getStatValue((ItemStack)stack, "fortification", "increase") * ((float)hasCyber * 0.5f + 1.0f);
            }
            if (item.isAbilityUnlocked((ItemStack)stack, "acquired_immunity")) {
                canTransformPoison[0] = true;
            }
        });
        MobEffectInstance instance = event.getEffectInstance();
        if (VertebraX.modifyEffect((LivingEntity)player, instance, canTransformPoison, increaseAmount, reductionAmount)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
        currentlyInPotionEvent = false;
    }

    public static boolean modifyEffect(LivingEntity player, MobEffectInstance instance, boolean[] canTransformPoison, float[] increaseAmount, float[] reductionAmount) {
        if (instance.is(MobEffects.LEVITATION)) {
            return false;
        }
        if (canTransformPoison[0] && instance.is(MobEffects.POISON)) {
            VertebraX.transformPoisonToRegeneration(player, instance, increaseAmount[0]);
        } else if (increaseAmount[0] > 0.0f && ((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL) {
            VertebraX.increaseEffectDuration(player, instance, increaseAmount[0]);
        } else if (reductionAmount[0] > 0.0f && ((MobEffect)instance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
            VertebraX.reduceEffectDuration(player, instance, reductionAmount[0]);
        } else {
            return false;
        }
        return true;
    }

    private static void transformPoisonToRegeneration(LivingEntity player, MobEffectInstance poisonInstance, float increasePercent) {
        int originalDuration = poisonInstance.getDuration();
        int increasedDuration = (int)((float)originalDuration * (1.0f + increasePercent / 100.0f));
        MobEffectInstance regenEffect = new MobEffectInstance(MobEffects.REGENERATION, increasedDuration, poisonInstance.getAmplifier(), poisonInstance.isAmbient(), poisonInstance.isVisible(), poisonInstance.showIcon());
        player.addEffect(regenEffect);
    }

    private static void increaseEffectDuration(LivingEntity player, MobEffectInstance instance, float increasePercent) {
        int originalDuration = instance.getDuration();
        int increasedDuration = (int)((float)originalDuration * (1.0f + increasePercent / 100.0f));
        MobEffectInstance newInstance = new MobEffectInstance(instance.getEffect(), increasedDuration, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon());
        player.addEffect(newInstance);
    }

    private static void reduceEffectDuration(LivingEntity player, MobEffectInstance instance, float reductionPercent) {
        int originalDuration = instance.getDuration();
        int reducedDuration = (int)((float)originalDuration * (1.0f - reductionPercent / 100.0f));
        MobEffectInstance newInstance = new MobEffectInstance(instance.getEffect(), reducedDuration, instance.getAmplifier(), instance.isAmbient(), instance.isVisible(), instance.showIcon());
        player.addEffect(newInstance);
    }
}

