/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.LocationHolder;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class TyrantMask
extends MoreRelicBase {
    final int requiredDistance = 15000;
    final int requiredKills = 300;
    final int requiredBlocks = 1200;

    public TyrantMask(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"regrets").stat(StatData.builder((String)"debuff").initialValue(20.0, 20.0).build()).build()).ability(AbilityData.builder((String)"revenge").build()).ability(AbilityData.builder((String)"monotony").build()).ability(AbilityData.builder((String)"futility").build()).build()).leveling(LevelingData.builder().maxLevel(1).initialCost(100).step(30).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.BASTION}).build()).build();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        this.getAbilityComponent(stack, "regrets").toBuilder();
        super.onEquip(slotContext, prevStack, stack);
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.TYRANT_MASK.get())).forEach(stack -> {
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof TyrantMask)) {
                return;
            }
            TyrantMask item = (TyrantMask)patt0$temp;
            LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
            if (holder.y < (double)item.requiredKills) {
                holder.y += 1.0;
                item.checkAndChange(holder, (ItemStack)stack, player);
            }
        });
    }

    @SubscribeEvent
    public static void onPlace(BlockEvent.EntityPlaceEvent event) {
        Player player;
        block3: {
            block2: {
                Entity entity = event.getEntity();
                if (!(entity instanceof Player)) break block2;
                player = (Player)entity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.TYRANT_MASK.get())).forEach(stack -> {
            TyrantMask item = (TyrantMask)stack.getItem();
            LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
            if (holder.z < (double)item.requiredBlocks) {
                holder.z += 1.0;
                item.checkAndChange(holder, (ItemStack)stack, player);
            }
        });
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return;
        }
        if (holder.x < 15000.0) {
            LocationHolder location = (LocationHolder)stack.get(DataComponentHandler.LOCATION_HOLDER.get());
            Vec3 playerPos = entity.getPosition(0.0f);
            if (location == null) {
                LocationHolder newHolder = new LocationHolder(playerPos.x, playerPos.y, playerPos.z);
                stack.set(DataComponentHandler.LOCATION_HOLDER.get(), (Object)newHolder);
            } else {
                holder.x += Math.sqrt(entity.distanceToSqr(location.x, location.y, location.z));
                location.setX(playerPos.x);
                location.setY(playerPos.y);
                location.setZ(playerPos.z);
                if (this.checkAndChange(holder, stack, player)) {
                    return;
                }
            }
        }
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)(-((float)this.getStatValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (float)(-((float)this.getStatValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.applyAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (float)(-((float)this.getStatValue(stack, "regrets", "debuff")) / 100.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        LocationHolder location = (LocationHolder)stack.get(DataComponentHandler.LOCATION_HOLDER.get());
        if (location != null) {
            LivingEntity entity = slotContext.entity();
            Vec3 playerPos = entity.getPosition(0.0f);
            location.setX(playerPos.x);
            location.setY(playerPos.y);
            location.setZ(playerPos.z);
        }
        super.onEquipFromUse(slotContext, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.getItem() != newStack.getItem()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    private boolean checkAndChange(LocationHolder holder, ItemStack stack, Player player) {
        if (holder.x >= 15000.0 && holder.y >= 300.0 && holder.z >= 1200.0) {
            EntityUtils.addItem((Player)player, (ItemStack)MoreRelics.KING_CRIMSON.toStack());
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SOUL_SAND_BREAK, SoundSource.MASTER, 1.2f, 0.3f);
            MutableComponent message = Component.literal((String)"The trapped souls within the mask are freed.").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
            player.sendSystemMessage((Component)message);
            this.spawnSoulParticles(player.level(), player.position());
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            stack.setCount(0);
            return true;
        }
        return false;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        LocationHolder holder = DataComponentHandler.getTripleStorage(stack);
        list.add((Component)Component.literal((String)("Distance Travelled: " + (int)holder.x + "/15000")).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC));
        list.add((Component)Component.literal((String)("Enemies Killed: " + (int)holder.y + "/300")).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC));
        list.add((Component)Component.literal((String)("Blocks Placed: " + (int)holder.z + "/1200")).withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC));
        return list;
    }

    private void spawnSoulParticles(Level level, Vec3 position) {
        int particleCount = 50;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = Math.random() * 1.5 + 0.8;
            double x = position.x + radius * Math.cos(angle);
            double y = position.y + Math.random() * 2.5;
            double z = position.z + radius * Math.sin(angle);
            ServerLevel sevLevel = (ServerLevel)level;
            List players = level.players();
            for (ServerPlayer player : players) {
                sevLevel.sendParticles(player, (ParticleOptions)ParticleTypes.SOUL, true, x, y, z, particleCount, 0.0, 0.0, 0.0, 0.7);
            }
        }
    }
}

