/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.dataComponents.StarCounter;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import top.theillusivec4.curios.api.SlotContext;

public class SlumberingAmulet
extends MoreRelicBase {
    public final int starEatTimer = 60;
    public final int expTimer = 10;

    public SlumberingAmulet(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"odd_aura").maxLevel(1).requiredLevel(0).build()).ability(AbilityData.builder((String)"awakening_potential").requiredLevel(10).maxLevel(1).build()).build()).leveling(LevelingData.builder().maxLevel(10).initialCost(75).step(50).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"odd_aura").initialValue(1).build()).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide) {
            return;
        }
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int expProgress = counter.current();
        if (expProgress < 10) {
            ++expProgress;
        } else {
            this.addRelicExperience(slotContext.entity(), stack, 1);
            expProgress = 0;
        }
        stack.set(DataComponentHandler.INT_COUNTER.get(), (Object)counter.getUpdatedCounter(expProgress));
        if (this.isAbilityUnlocked(stack, "awakening_potential")) {
            ItemStack mainHandItem = player.getMainHandItem();
            StarCounter starCounter = DataComponentHandler.getStarCounter(stack);
            int starEatProgress = starCounter.timerCurrent();
            int netherStartEaten = starCounter.count();
            if (mainHandItem.is(Items.NETHER_STAR)) {
                if (starEatProgress == 0) {
                    MutableComponent message = Component.translatable((String)"amulet.morerelics.absorbing_star").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF6666)));
                    player.sendSystemMessage((Component)message);
                    ++starEatProgress;
                } else if (starEatProgress < 60) {
                    ++starEatProgress;
                } else {
                    mainHandItem.consume(1, (LivingEntity)player);
                    if (++netherStartEaten < 3) {
                        MutableComponent message = Component.translatable((String)"amulet.morerelics.craves_more").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)14067711)));
                        player.sendSystemMessage((Component)message);
                        starEatProgress = 0;
                    } else {
                        MutableComponent message = Component.translatable((String)"amulet.morerelics.amulet_transforms").setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)16766720)));
                        player.sendSystemMessage((Component)message);
                        EntityUtils.addItem((Player)player, (ItemStack)MoreRelics.WHISPERING_AMULET.toStack());
                        stack.setCount(0);
                    }
                }
            } else {
                starEatProgress = 0;
            }
            stack.set(DataComponentHandler.STAR_COUNTER.get(), (Object)starCounter.getUpdatedCounter(netherStartEaten, starEatProgress));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        StarCounter starCounter = DataComponentHandler.getStarCounter(stack);
        stack.set(DataComponentHandler.STAR_COUNTER.get(), (Object)starCounter.getUpdatedCounter(starCounter.count(), 0));
        super.onUnequip(slotContext, newStack, stack);
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)"tooltip.morerelics.slumbering_amulet.source").withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.ITALIC));
        return list;
    }
}

