/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicsUtil;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public abstract class MoreRelicBase
extends RelicItem {
    public MoreRelicBase(Item.Properties properties) {
        super(properties);
    }

    public MoreRelicBase() {
        super(new Item.Properties().rarity(Rarity.RARE).stacksTo(1));
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        entity.setGlowingTag(true);
        return super.onEntityItemUpdate(stack, entity);
    }

    public String getConfigRoute() {
        return "morerelics";
    }

    public boolean canEquipMultipleCopies() {
        return true;
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        if (!this.canEquipMultipleCopies()) {
            ArrayList<Component> newList = new ArrayList<Component>(tooltips.stream().toList());
            newList.add((Component)Component.translatable((String)"tooltip.morerelics.only_one_disclaimer").withColor(Color.ORANGE.getRGB()));
            return newList;
        }
        return super.getSlotsTooltip(tooltips, context, stack);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        if (this.canEquipMultipleCopies()) {
            return super.canEquip(slotContext, stack);
        }
        boolean alreadyEquipped = MoreRelicsUtil.actuallyGetEquippedRelicsWithSlots(slotContext.entity()).stream().anyMatch(entry -> entry.stack().getItem().getClass() == ((Object)((Object)this)).getClass() && (slotContext.index() != entry.slotIndex() || !Objects.equals(slotContext.identifier(), entry.slotId())));
        if (alreadyEquipped && super.canEquip(slotContext, stack)) {
            return false;
        }
        return super.canEquip(slotContext, stack);
    }
}

