/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.dataComponents.VectorDequeHolder;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class KingCrimson
extends MoreRelicBase {
    public KingCrimson(Item.Properties properties) {
        super(new Item.Properties().rarity(Rarity.EPIC).stacksTo(1).fireResistant());
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"epitaph").stat(StatData.builder((String)"cooldown").initialValue(200.0, 140.0).upgradeModifier(UpgradeOperation.ADD, -30.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(4).requiredLevel(0).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).build()).ability(AbilityData.builder((String)"talk_to_the_wind").stat(StatData.builder((String)"seconds").initialValue(3.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 1.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"chance").initialValue(3.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(3).build()).ability(AbilityData.builder((String)"the_court").stat(StatData.builder((String)"threshold").initialValue(7.0, 12.0).upgradeModifier(UpgradeOperation.ADD, 1.2).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(7).build()).build()).leveling(LevelingData.builder().maxLevel(14).initialCost(10).step(30).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"epitaph").initialValue(1).build()).source(LevelingSourceData.abilityBuilder((String)"the_court").initialValue(1).build()).source(LevelingSourceData.abilityBuilder((String)"talk_to_the_wind").initialValue(1).build()).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        IntegerCounter counter = DataComponentHandler.getIntegerCounter(stack);
        int ticks = counter.current();
        if (20 > ticks) {
            ++ticks;
        } else {
            LivingEntity entity = slotContext.entity();
            Level clientLevel = entity.level();
            if (clientLevel.getServer() == null) {
                return;
            }
            ServerLevel serverLevel = clientLevel.getServer().getLevel(clientLevel.dimension());
            ticks = 0;
            VectorDequeHolder vecHolder = DataComponentHandler.getVecDeque(stack);
            vecHolder.addVecAndLevel(entity.position(), serverLevel);
            stack.set(DataComponentHandler.VECTOR_DEQUE_HOLDER.get(), (Object)vecHolder);
        }
        stack.set(DataComponentHandler.INT_COUNTER, (Object)counter.getUpdatedCounter(ticks));
        super.curioTick(slotContext, stack);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.level().isClientSide) {
            return;
        }
        if (ability.equals("epitaph")) {
            VectorDequeHolder vecHolder = DataComponentHandler.getVecDeque(stack);
            Vec3 oldestPos = vecHolder.getOldestVec();
            ServerLevel level = vecHolder.getOldestLevel();
            if (oldestPos == null || level == null) {
                return;
            }
            player.resetFallDistance();
            player.teleportTo(level, oldestPos.x, oldestPos.y, oldestPos.z, Set.of(RelativeMovement.X, RelativeMovement.Y), player.getYRot(), player.getXRot());
            this.setAbilityCooldown(stack, "epitaph", (int)this.getStatValue(stack, "epitaph", "cooldown") * 20);
            this.spreadRelicExperience((LivingEntity)player, stack, 20);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingIncomingDamageEvent event) {
        Player player;
        block7: {
            block6: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (!player.level().isClientSide) break block7;
            }
            return;
        }
        if ((float)event.getEntity().invulnerableTime > 10.0f && !event.getSource().is(DamageTypeTags.BYPASSES_COOLDOWN) && event.getAmount() <= event.getEntity().lastHurt) {
            return;
        }
        LivingEntity victim = event.getEntity();
        float effectSeconds = (float)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.KING_CRIMSON.get())).stream().mapToDouble(stack -> {
            KingCrimson item = (KingCrimson)stack.getItem();
            if (!item.isAbilityUnlocked((ItemStack)stack, "talk_to_the_wind")) {
                return 0.0;
            }
            Random rand = new Random();
            if ((double)rand.nextFloat(0.0f, 100.0f) < item.getStatValue((ItemStack)stack, "talk_to_the_wind", "chance")) {
                item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 2);
                return item.getStatValue((ItemStack)stack, "talk_to_the_wind", "seconds");
            }
            return 0.0;
        }).sum();
        if (effectSeconds > 0.0f) {
            MobEffectInstance weakness = new MobEffectInstance(MobEffects.WEAKNESS, (int)(effectSeconds * 20.0f));
            MobEffectInstance slowness = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, (int)(effectSeconds * 20.0f));
            victim.addEffect(weakness);
            victim.addEffect(slowness);
            if (victim instanceof Player) {
                MobEffectInstance staticEffect = new MobEffectInstance(MoreRelics.STATIC, (int)(effectSeconds * 20.0f));
                victim.addEffect(staticEffect);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerAttackExec(LivingDamageEvent.Pre event) {
        Player player;
        block7: {
            block6: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (!player.level().isClientSide) break block7;
            }
            return;
        }
        if (event.getSource().type().msgId().equals("morerelics_king_crimson")) {
            return;
        }
        if (event.getEntity().isDeadOrDying()) {
            return;
        }
        LivingEntity victim = event.getEntity();
        int shouldExecute = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.KING_CRIMSON.get())).stream().mapToInt(stack -> {
            KingCrimson item = (KingCrimson)stack.getItem();
            if (!item.isAbilityUnlocked((ItemStack)stack, "the_court")) {
                return 0;
            }
            float ratio = (victim.getHealth() - event.getNewDamage()) / victim.getMaxHealth();
            if (!victim.isDeadOrDying() && ratio > 0.0f && (double)ratio <= item.getStatValue((ItemStack)stack, "the_court", "threshold") / 100.0) {
                item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 3);
                return 1;
            }
            return 0;
        }).sum();
        if (shouldExecute >= 1) {
            KingCrimson.spawnGlitchedSoulParticles(victim.level(), victim.position());
            event.setNewDamage(event.getNewDamage() + victim.getHealth() * 1.1f);
        }
    }

    private static void spawnGlitchedSoulParticles(Level level, Vec3 position) {
        int particleCount = 20;
        level.playSound(null, position.x, position.y, position.z, MoreRelics.EXECUTE, SoundSource.MASTER, 1.0f, 1.0f);
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.players();
        for (ServerPlayer player : players) {
            sevLevel.sendParticles(player, (ParticleOptions)MoreRelics.GLITCHED_SOUL.get(), true, position.x, position.y + 1.0, position.z, particleCount, 0.0, 0.0, 0.0, 0.07);
        }
    }
}

