/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.OptionalDouble;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class GravitumGlove
extends MoreRelicBase {
    public GravitumGlove(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"all_in").stat(StatData.builder((String)"damage_boost").initialValue(1.4, 1.7).upgradeModifier(UpgradeOperation.ADD, 0.06).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).ability(AbilityData.builder((String)"bonk").stat(StatData.builder((String)"chance").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.25).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"duration").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 2.5).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(4).requiredLevel(5).build()).build()).leveling(LevelingData.builder().maxLevel(9).initialCost(90).step(20).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"all_in").initialValue(1).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.END_LIKE, LootEntries.THE_END, LootEntries.SCULK}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.level().isClientSide) {
            return;
        }
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (float)-0.667f, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        EntityUtils.resetAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (float)((float)this.getStatValue(stack, "all_in", "damage_boost") - 1.0f), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (stack.getItem() != newStack.getItem()) {
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_DAMAGE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            EntityUtils.removeAttribute((LivingEntity)livingEntity, (ItemStack)stack, (Holder)Attributes.ATTACK_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingIncomingDamageEvent event) {
        Player player;
        block6: {
            block5: {
                Entity entity = event.getSource().getEntity();
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (!player.level().isClientSide) break block6;
            }
            return;
        }
        OptionalDouble effectSeconds = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.GRAVITON_GLOVE.get())).stream().mapToDouble(stack -> {
            GravitumGlove item = (GravitumGlove)stack.getItem();
            item.spreadRelicExperience((LivingEntity)player, (ItemStack)stack, 2);
            if (!item.isAbilityUnlocked((ItemStack)stack, "bonk")) {
                return 0.0;
            }
            if (event.getOriginalAmount() < 20.0f) {
                return 0.0;
            }
            double perch = item.getStatValue((ItemStack)stack, "bonk", "chance");
            Random rand = new Random();
            if ((double)rand.nextFloat(0.0f, 100.0f) < perch) {
                return item.getStatValue((ItemStack)stack, "bonk", "duration");
            }
            return 0.0;
        }).max();
        if (effectSeconds.isEmpty()) {
            return;
        }
        double seconds = effectSeconds.getAsDouble();
        if (seconds > 0.0) {
            event.setAmount(event.getAmount() * 2.0f);
            LivingEntity victim = event.getEntity();
            ServerLevel sevLevel = (ServerLevel)victim.level();
            GravitumGlove.spawnSmashAttackParticles(sevLevel, victim.getOnPos(), 300);
            victim.level().playSound(null, victim.position().x, victim.position().y, victim.position().z, MoreRelics.BONK, SoundSource.MASTER, 1.0f, 1.0f);
            MobEffectInstance dazed = new MobEffectInstance(MoreRelics.DAZED, (int)(seconds * 20.0));
            event.getEntity().addEffect(dazed);
        }
    }

    public static void spawnSmashAttackParticles(ServerLevel level, BlockPos pos, int power) {
        Vec3 vec3 = pos.getCenter().add(0.0, 0.5, 0.0);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.DUST_PILLAR, level.getBlockState(pos));
        int i = 0;
        while ((float)i < (float)power / 3.0f) {
            double d0 = vec3.x + level.getRandom().nextGaussian() / 2.0;
            double d1 = vec3.y;
            double d2 = vec3.z + level.getRandom().nextGaussian() / 2.0;
            double d3 = level.getRandom().nextGaussian() * (double)0.2f;
            double d4 = level.getRandom().nextGaussian() * (double)0.2f;
            double d5 = level.getRandom().nextGaussian() * (double)0.2f;
            level.sendParticles((ParticleOptions)blockparticleoption, d0, d1, d2, 1, d3, d4, d5, 0.0);
            ++i;
        }
        int j = 0;
        while ((float)j < (float)power / 1.5f) {
            double d6 = vec3.x + 1.5 * Math.cos(j) + level.getRandom().nextGaussian() / 2.0;
            double d7 = vec3.y;
            double d8 = vec3.z + 1.5 * Math.sin(j) + level.getRandom().nextGaussian() / 2.0;
            double d9 = level.getRandom().nextGaussian() * (double)0.05f;
            double d10 = level.getRandom().nextGaussian() * (double)0.05f;
            double d11 = level.getRandom().nextGaussian() * (double)0.05f;
            level.sendParticles((ParticleOptions)blockparticleoption, d6, d7, d8, 1, d9, d10, d11, 0.0);
            ++j;
        }
    }
}

