/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.dataComponents.DataComponentHandler;
import com.blorb.morerelics.dataComponents.DoubleCounter;
import com.blorb.morerelics.dataComponents.IntegerCounter;
import com.blorb.morerelics.relics.MoreRelicBase;
import com.blorb.morerelics.relics.WonderOfU;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class ConvergingOrb
extends MoreRelicBase {
    public static final float requiredDamage = 400.0f;

    public ConvergingOrb(Item.Properties properties) {
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"convergence").maxLevel(1).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(1).initialCost(1).step(1).build()).build();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerAttacked(LivingDamageEvent.Pre event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block3;
            }
            return;
        }
        EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)MoreRelics.CONVERGING_ORB.get())).forEach(stack -> {
            ConvergingOrb item = (ConvergingOrb)stack.getItem();
            ConvergingOrb.increaseDensity(stack, (LivingEntity)player, event.getNewDamage());
            if (ConvergingOrb.isFinalQuestEnabled(stack) && event.getSource().is(DamageTypes.SONIC_BOOM)) {
                MutableComponent message = Component.translatable((String)"tooltip.morerelics.converging_orb.collapse").withStyle(ChatFormatting.AQUA);
                player.level().playSound(null, player.position().x, player.position().y, player.position().z, MoreRelics.WONDER, SoundSource.MASTER, 1.0f, 1.0f);
                WonderOfU.spawnWonderExplosionParticles(player.level(), player.position(), 4.0f);
                player.sendSystemMessage((Component)message);
                EntityUtils.addItem((Player)player, (ItemStack)MoreRelics.WONDER_OF_U.toStack());
                stack.setCount(0);
            }
        });
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public static void increaseDensity(ItemStack stack, LivingEntity entity, float damage) {
        DoubleCounter damageCounter = DataComponentHandler.getDoubleCounter(stack);
        double currentDamage = damageCounter.getCurrent();
        currentDamage = Math.clamp(currentDamage + (double)damage, 0.0, 400.0);
        damageCounter.setCurrent(currentDamage);
        IntegerCounter stateCounter = DataComponentHandler.getAltIntegerCounter(stack);
        int currentState = currentDamage < 100.0 ? 0 : (currentDamage < 200.0 ? 1 : (currentDamage < 400.0 ? 2 : 3));
        stack.set(DataComponentHandler.ALT_INT_COUNTER, (Object)stateCounter.getUpdatedCounter(currentState));
        if (currentState == 3) {
            ConvergingOrb.tryProcFinalQuest(stack, entity);
        }
    }

    public static void tryProcFinalQuest(ItemStack stack, LivingEntity entity) {
        IntegerCounter getAlreadyEnableCounter = DataComponentHandler.getIntegerCounter(stack);
        if (getAlreadyEnableCounter.current() == 1) {
            return;
        }
        MutableComponent message = Component.translatable((String)"amulet.morerelics.orb_final_push").withStyle(ChatFormatting.AQUA);
        entity.sendSystemMessage((Component)message);
        stack.set(DataComponentHandler.INT_COUNTER, (Object)getAlreadyEnableCounter.getUpdatedCounter(1));
    }

    public static boolean isFinalQuestEnabled(ItemStack stack) {
        IntegerCounter getAlreadyEnableCounter = DataComponentHandler.getIntegerCounter(stack);
        return getAlreadyEnableCounter.current() == 1;
    }

    public String damageToDensityString(ItemStack stack) {
        DoubleCounter damageCounter = DataComponentHandler.getDoubleCounter(stack);
        double damage = damageCounter.getCurrent();
        double baseDensity = 100.0;
        double maxDensity = 4.0 * Math.pow(10.0, 14.0);
        double k = Math.log(maxDensity / baseDensity) / 400.0;
        double density = baseDensity * Math.exp(k * damage);
        double logDensity = Math.log10(density);
        int exponent = (int)Math.floor(logDensity);
        double coefficient = density / Math.pow(10.0, exponent);
        String result = exponent >= 3 ? String.format("%.1f * 10^%d kg/m^3", coefficient, exponent) : String.format("%.0f kg/m^3", density);
        return result;
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, Item.TooltipContext context, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        String densityString = this.damageToDensityString(stack);
        String tooltipText = Component.translatable((String)"tooltip.morerelics.converging_orb.density").withStyle(ChatFormatting.AQUA).getString() + ": " + densityString;
        list.add((Component)Component.literal((String)tooltipText).withStyle(ChatFormatting.AQUA));
        if (ConvergingOrb.isFinalQuestEnabled(stack)) {
            list.add((Component)Component.translatable((String)"tooltip.morerelics.converging_orb.final_task").withStyle(ChatFormatting.LIGHT_PURPLE).withStyle(ChatFormatting.ITALIC));
        }
        return list;
    }
}

