/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.effects;

import com.blorb.morerelics.MoreRelics;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import org.jetbrains.annotations.NotNull;

public class Nullification
extends MobEffect {
    public static boolean isRendering = false;

    public Nullification() {
        super(MobEffectCategory.BENEFICIAL, 0xFFFFFF);
    }

    @EventBusSubscriber(modid="morerelics", value={Dist.CLIENT})
    public static class ClientEvent {
        private static final Map<ResourceLocation, ResourceLocation> cache = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();
        private static final float OUTLINE_THICKNESS = 0.06f;

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onEntityRender(RenderLivingEvent.Pre<?, ?> event) {
            LivingEntity entity = event.getEntity();
            if (entity.isInvisible() || !entity.hasEffect(MoreRelics.NULLIFICATION)) {
                return;
            }
            if (isRendering) {
                return;
            }
            isRendering = true;
            MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
            immediate.endBatch();
            PoseStack poseStack = ClientEvent.getScaledPoseStack(event, entity);
            ClientEvent.setTransparency(1.0f);
            ClientEvent.renderTranslucentEntity(event.getEntity(), poseStack, (MultiBufferSource)immediate, event.getPackedLight(), event.getPartialTick());
            immediate.endBatch();
            ClientEvent.resetTransparency();
            poseStack.popPose();
            isRendering = false;
        }

        @NotNull
        private static PoseStack getScaledPoseStack(RenderLivingEvent.Pre<?, ?> event, LivingEntity entity) {
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            AABB box = entity.getBoundingBox();
            double entityWidth = box.getXsize();
            double entityHeight = box.getYsize();
            double entityDepth = box.getZsize();
            float scaleX = (float)((entityWidth + (double)0.12f) / entityWidth);
            float scaleY = (float)((entityHeight + (double)0.12f) / entityHeight);
            float scaleZ = (float)((entityDepth + (double)0.12f) / entityDepth);
            poseStack.scale(scaleX, scaleY, scaleZ);
            return poseStack;
        }

        private static void setTransparency(float alpha) {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        }

        private static void renderTranslucentEntity(LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int light, float partialTick) {
            EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                livingRenderer.render(entity, 0.0f, partialTick, poseStack, buffer, light);
            }
        }

        private static void resetTransparency() {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }

        @SubscribeEvent
        public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
            for (PlayerSkin.Model skin : event.getSkins()) {
                PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skin);
                if (renderer == null) continue;
            }
        }
    }
}

