/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.natte.tankstorage.item.TankFunctionality;
import net.natte.tankstorage.state.TankFluidStorageState;
import net.natte.tankstorage.storage.TankFluidHandler;
import net.natte.tankstorage.storage.TankInteractionMode;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;

public class BucketInteraction {
    public static InteractionResult interactFluid(Level world, Player player, InteractionHand hand, ItemStack stack) {
        TankFluidHandler fluidStorage;
        if (!Util.hasUUID(stack)) {
            return InteractionResult.PASS;
        }
        assert (Util.getInteractionMode(stack) == TankInteractionMode.BUCKET) : "cannot interact with fluids in world if not in bucket mode";
        TankFluidStorageState tankState = null;
        if (!world.isClientSide) {
            tankState = Util.getFluidStorage(stack);
        }
        if ((fluidStorage = Util.getFluidHandlerFromItem(stack)) == null) {
            return InteractionResult.FAIL;
        }
        FluidStack selectedFluid = Util.getSelectedFluid(stack);
        if (selectedFluid == null) {
            InteractionResult result = BucketInteraction.pickUpFluid(world, player, stack);
            if (result.consumesAction() && !world.isClientSide) {
                tankState.sync((ServerPlayer)player);
                Util.clampSelectedSlotServer(stack);
            }
            return result;
        }
        InteractionResult result = BucketInteraction.placeFluid(selectedFluid, world, player, hand, stack);
        if (result.consumesAction() && !world.isClientSide) {
            tankState.sync((ServerPlayer)player);
            Util.clampSelectedSlotServer(stack);
        }
        return result;
    }

    public static InteractionResult placeFluid(FluidStack fluidVariant, Level world, Player player, InteractionHand hand, ItemStack stack) {
        LiquidBlockContainer liquidBlockContainer;
        assert (!fluidVariant.isEmpty()) : "cannot place blank fluid";
        Fluid fluid = fluidVariant.getFluid();
        if (!Util.canPlaceFluid(fluid)) {
            return InteractionResult.PASS;
        }
        BlockHitResult hit = TankFunctionality.raycast(world, player, ClipContext.Fluid.NONE);
        if (hit.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = hit.getBlockPos();
        Direction direction = hit.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        boolean canPlaceFluidInBlock = block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)world, blockPos, blockState, fluid);
        BlockPos blockPos3 = canPlaceFluidInBlock ? blockPos : blockPos2;
        FluidActionResult result = FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)blockPos3, (ItemStack)stack, (FluidStack)fluidVariant.copyWithAmount(1000));
        return result.isSuccess() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public static InteractionResult pickUpFluid(Level world, Player player, ItemStack stack) {
        BlockHitResult hit = TankFunctionality.raycast(world, player, ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (hit.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = hit.getBlockPos();
        Direction direction = hit.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (!world.mayInteract(player, blockPos) || !player.mayUseItemAt(blockPos2, direction, stack)) {
            return InteractionResult.FAIL;
        }
        Fluid fluid = world.getFluidState(blockPos).getType();
        if (fluid == Fluids.EMPTY) {
            return InteractionResult.FAIL;
        }
        FluidActionResult fluidActionResult = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)world, (BlockPos)blockPos, (Direction)direction);
        return fluidActionResult.isSuccess() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }
}

